/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.types;

import io.confluent.ksql.function.types.ObjectType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import java.util.Objects;

public final class MapType
extends ObjectType {
    private final ParamType value;

    private MapType(ParamType value) {
        this.value = value;
    }

    public static MapType of(ParamType value) {
        return new MapType(value);
    }

    public ParamType key() {
        return ParamTypes.STRING;
    }

    public ParamType value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        return Objects.equals(this.value, mapType.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public String toString() {
        return "MAP<STRING, " + this.value + ">";
    }
}

