/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.DecimalFormat;
import org.apache.kafka.connect.json.JsonConverter;

public class StructSerializationModule
extends SimpleModule {
    private static final JsonConverter jsonConverter = new JsonConverter();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public StructSerializationModule() {
        jsonConverter.configure((Map)ImmutableMap.of((Object)"schemas.enable", (Object)false, (Object)"decimal.format", (Object)DecimalFormat.NUMERIC.name()), false);
        this.addSerializer(Struct.class, new Serializer());
    }

    static class Serializer
    extends JsonSerializer<Struct> {
        Serializer() {
        }

        public void serialize(Struct struct, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            struct.validate();
            jsonGenerator.writeObject((Object)objectMapper.readTree(jsonConverter.fromConnectData("", struct.schema(), (Object)struct)));
        }
    }
}

