/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import io.confluent.ksql.metrics.TopicSensors;
import java.util.Collection;
import java.util.stream.Collectors;

public final class MetricUtils {
    private MetricUtils() {
    }

    public static <T> double aggregateStat(String name, boolean isError, Collection<TopicSensors<T>> sensors) {
        return sensors.stream().flatMap(r -> r.stats(isError).stream()).filter(s -> s.name().equals(name)).mapToDouble(TopicSensors.Stat::getValue).sum();
    }

    public static <T> Collection<TopicSensors.Stat> stats(String topic, boolean isError, Collection<TopicSensors<T>> sensors) {
        return sensors.stream().filter(counter -> counter.isTopic(topic)).flatMap(r -> r.stats(isError).stream()).collect(Collectors.toList());
    }
}

