/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.common.utils.Time;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;

class TopicSensors<R> {
    private final String topic;
    private final List<SensorMetric<R>> sensors;

    TopicSensors(String topic, List<SensorMetric<R>> sensors) {
        this.topic = topic.toLowerCase();
        this.sensors = sensors;
    }

    void increment(R record, boolean isError) {
        this.sensors.forEach(v -> {
            if (v.isError() == isError) {
                v.record(record);
            }
        });
    }

    public void close(Metrics metrics) {
        this.sensors.forEach(v -> v.close(metrics));
    }

    boolean isTopic(String topic) {
        return this.topic.equals(topic);
    }

    Collection<Stat> stats(boolean isError) {
        return this.sensors.stream().filter(sensor -> ((SensorMetric)sensor).errorMetric == isError).map(SensorMetric::asStat).collect(Collectors.toList());
    }

    Collection<Stat> errorRateStats() {
        return this.sensors.stream().filter(sensor -> sensor.isError() && sensor.isRate()).map(SensorMetric::asStat).collect(Collectors.toList());
    }

    static class SensorMetric<P> {
        private final Sensor sensor;
        private final KafkaMetric metric;
        private final Time time;
        private final boolean errorMetric;
        private long lastEvent = 0L;

        SensorMetric(Sensor sensor, KafkaMetric metric, Time time, boolean errorMetric) {
            this.sensor = sensor;
            this.metric = metric;
            this.time = time;
            this.errorMetric = errorMetric;
        }

        public boolean isError() {
            return this.errorMetric;
        }

        void record(P object) {
            this.lastEvent = this.time.milliseconds();
        }

        public double value() {
            return (Double)this.metric.metricValue();
        }

        public void close(Metrics metrics) {
            metrics.removeSensor(this.sensor.name());
            metrics.removeMetric(this.metric.metricName());
        }

        public boolean isRate() {
            return this.metric.measurable() instanceof Rate;
        }

        public String toString() {
            return super.toString() + " " + this.asStat().toString();
        }

        Stat asStat() {
            return new Stat(this.metric.metricName().name(), this.value(), this.lastEvent);
        }
    }

    static class Stat {
        private final String name;
        private double value;
        private final long timestamp;

        Stat(String name, double value, long timestamp) {
            this.name = name;
            this.value = value;
            this.timestamp = timestamp;
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        String formatted() {
            if (this.value == (double)Math.round(this.value)) {
                return String.format("%16s:%10.0f", this.name, this.value);
            }
            return String.format("%16s:%10.2f", this.name, this.value);
        }

        public String timestamp() {
            if (this.timestamp == 0L) {
                return "n/a";
            }
            return Instant.ofEpochMilli(this.timestamp).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stat stat = (Stat)o;
            if (Double.compare(stat.value, this.value) != 0) {
                return false;
            }
            if (Double.compare(stat.timestamp, this.timestamp) != 0) {
                return false;
            }
            return Objects.equals(this.name, stat.name);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.timestamp);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).add("timestamp", this.timestamp).toString();
        }

        public String name() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Stat aggregate(double value) {
            this.value += value;
            return this;
        }
    }
}

