/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.config.PropertyParser;
import io.confluent.ksql.properties.LocalPropertyParser;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LocalProperties {
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final PropertyParser parser;

    public LocalProperties(Map<String, ?> initial) {
        this(initial, new LocalPropertyParser());
    }

    @VisibleForTesting
    LocalProperties(Map<String, ?> initial, PropertyParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser");
        try {
            Objects.requireNonNull(initial, "initial").forEach(this::set);
        }
        catch (Exception e) {
            throw new KsqlException("invalid property found: " + e.getMessage(), e);
        }
    }

    public Object set(String property, Object value) {
        Objects.requireNonNull(value, "value");
        Object parsed = this.parser.parse(property, value);
        return this.props.put(property, parsed);
    }

    public Object unset(String property) {
        return this.props.remove(property);
    }

    public Map<String, Object> toMap() {
        return ImmutableMap.copyOf(this.props);
    }
}

