/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;

@Immutable
public final class Column
implements SimpleColumn {
    private final ColumnName name;
    private final SqlType type;
    private final Namespace namespace;
    private final int index;

    @Deprecated
    public static Column legacyKeyFieldColumn(ColumnName name, SqlType type) {
        return Column.of(name, type, Namespace.VALUE, Integer.MAX_VALUE);
    }

    public static Column of(ColumnName name, SqlType type, Namespace namespace, int indexWithinNamespace) {
        return new Column(name, type, namespace, indexWithinNamespace);
    }

    private Column(ColumnName name, SqlType type, Namespace namespace, int index) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.index = index;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid column index: " + index);
        }
    }

    @Override
    public ColumnName name() {
        return this.name;
    }

    @Override
    public SqlType type() {
        return this.type;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public int index() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.index, that.index) && Objects.equals((Object)this.namespace, (Object)that.namespace) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.namespace, this.name, this.type});
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        String fmtNs = this.namespace == Namespace.VALUE ? "" : " " + (Object)((Object)this.namespace);
        String fmtType = this.type.toString(formatOptions);
        return this.name.toString(formatOptions) + " " + fmtType + fmtNs;
    }

    public static enum Namespace {
        KEY,
        VALUE;

    }
}

