/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import org.apache.kafka.streams.KafkaStreams;

public final class KsqlConstants {
    public static final String CONFLUENT_AUTHOR = "Confluent";
    public static final String STREAMS_CHANGELOG_TOPIC_SUFFIX = "-changelog";
    public static final String STREAMS_REPARTITION_TOPIC_SUFFIX = "-repartition";
    public static final String SCHEMA_REGISTRY_VALUE_SUFFIX = "-value";
    public static final long defaultSinkWindowChangeLogAdditionalRetention = 1000000L;
    public static final long defaultCommitIntervalMsConfig = 2000L;
    public static final long defaultCacheMaxBytesBufferingConfig = 10000000L;
    public static final int defaultNumberOfStreamsThreads = 4;
    public static final String LEGACY_RUN_SCRIPT_STATEMENTS_CONTENT = "ksql.run.script.statements";
    public static final String DOT = ".";
    public static final String STRUCT_FIELD_REF = "->";
    public static final String AVRO_SCHEMA_NAMESPACE = "io.confluent.ksql.avro_schemas";
    public static final String AVRO_SCHEMA_NAME = "KsqlDataSourceSchema";
    public static final String DEFAULT_AVRO_SCHEMA_FULL_NAME = "io.confluent.ksql.avro_schemas.KsqlDataSourceSchema";
    public static final String TIME_PATTERN = "HH:mm:ss.SSS";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    private KsqlConstants() {
    }

    public static KsqlQueryStatus fromStreamsState(KafkaStreams.State state) {
        return state == KafkaStreams.State.ERROR ? KsqlQueryStatus.ERROR : KsqlQueryStatus.RUNNING;
    }

    public static enum KsqlQueryStatus {
        RUNNING,
        ERROR,
        UNRESPONSIVE;

    }

    public static enum KsqlQueryType {
        PERSISTENT,
        PUSH;

    }
}

