/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.connect.SchemaFormatter;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;

@Immutable
public final class QuerySchemas {
    @EffectivelyImmutable
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(word -> false, SqlSchemaFormatter.Option.APPEND_NOT_NULL);
    @EffectivelyImmutable
    private final SchemaFormatter schemaFormatter;
    private final ImmutableList<Entry> schemas;

    public static QuerySchemas of(LinkedHashMap<String, PersistenceSchema> schemas) {
        return new QuerySchemas(schemas, (SchemaFormatter)FORMATTER);
    }

    @VisibleForTesting
    QuerySchemas(LinkedHashMap<String, PersistenceSchema> schemas, SchemaFormatter schemaFormatter) {
        this(schemas.entrySet().stream().map(e -> new Entry((String)e.getKey(), (PersistenceSchema)e.getValue())).collect(Collectors.toList()), schemaFormatter);
    }

    private QuerySchemas(List<Entry> schemas, SchemaFormatter schemaFormatter) {
        this.schemas = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemas, "schemas"));
        this.schemaFormatter = Objects.requireNonNull(schemaFormatter, "schemaFormatter");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySchemas that = (QuerySchemas)o;
        return Objects.equals(this.schemas, that.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.schemas);
    }

    public Map<String, String> getSchemasDescription() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Entry e : this.schemas) {
            builder.put((Object)e.loggerNamePrefix, (Object)this.schemaFormatter.format((Schema)e.schema.serializedSchema()));
        }
        return builder.build();
    }

    public String toString() {
        return this.schemas.stream().map(e -> ((Entry)e).loggerNamePrefix + " = " + this.schemaFormatter.format((Schema)((Entry)e).schema.serializedSchema())).collect(Collectors.joining(System.lineSeparator()));
    }

    @Immutable
    private static final class Entry {
        private final String loggerNamePrefix;
        private final PersistenceSchema schema;

        private Entry(String loggerNamePrefix, PersistenceSchema schema) {
            this.loggerNamePrefix = Objects.requireNonNull(loggerNamePrefix, "loggerNamePrefix");
            this.schema = Objects.requireNonNull(schema, "schema");
        }
    }
}

