/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.Streams;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReservedInternalTopics {
    private static final Logger LOG = LoggerFactory.getLogger(ReservedInternalTopics.class);
    public static final String KSQL_INTERNAL_TOPIC_PREFIX = "_confluent-ksql-";
    public static final String KSQL_COMMAND_TOPIC_SUFFIX = "command_topic";
    public static final String KSQL_CONFIGS_TOPIC_SUFFIX = "configs";
    private final Pattern hiddenTopicsPattern;
    private final Pattern readOnlyTopicsPattern;

    public static String commandTopic(KsqlConfig ksqlConfig) {
        return ReservedInternalTopics.toKsqlInternalTopic(ksqlConfig, KSQL_COMMAND_TOPIC_SUFFIX);
    }

    public static String configsTopic(KsqlConfig ksqlConfig) {
        return ReservedInternalTopics.toKsqlInternalTopic(ksqlConfig, KSQL_CONFIGS_TOPIC_SUFFIX);
    }

    public static String processingLogTopic(ProcessingLogConfig config, KsqlConfig ksqlConfig) {
        String topicNameConfig = config.getString(ProcessingLogConfig.TOPIC_NAME);
        if (topicNameConfig.equals("")) {
            return String.format("%s%s", ksqlConfig.getString("ksql.service.id"), "ksql_processing_log");
        }
        return topicNameConfig;
    }

    private static String toKsqlInternalTopic(KsqlConfig ksqlConfig, String topicSuffix) {
        return String.format("%s%s_%s", KSQL_INTERNAL_TOPIC_PREFIX, ksqlConfig.getString("ksql.service.id"), topicSuffix);
    }

    public ReservedInternalTopics(KsqlConfig ksqlConfig) {
        ProcessingLogConfig processingLogConfig = new ProcessingLogConfig(ksqlConfig.getProcessingLogConfigProps());
        this.hiddenTopicsPattern = Pattern.compile(Streams.concat((Stream[])new Stream[]{Stream.of("_confluent-ksql-.*"), ksqlConfig.getList("ksql.hidden.topics").stream()}).collect(Collectors.joining("|")));
        this.readOnlyTopicsPattern = Pattern.compile(Streams.concat((Stream[])new Stream[]{Stream.of(ReservedInternalTopics.processingLogTopic(processingLogConfig, ksqlConfig)), Stream.of("_confluent-ksql-.*"), ksqlConfig.getList("ksql.readonly.topics").stream()}).collect(Collectors.joining("|")));
    }

    public Set<String> removeHiddenTopics(Set<String> topicNames) {
        return topicNames.stream().filter(t -> !this.isHidden((String)t)).collect(Collectors.toSet());
    }

    public boolean isHidden(String topicName) {
        return this.hiddenTopicsPattern.matcher(topicName).matches();
    }

    public boolean isReadOnly(String topicName) {
        return this.readOnlyTopicsPattern.matcher(topicName).matches();
    }
}

