/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class WelcomeMsgUtils {
    private WelcomeMsgUtils() {
    }

    public static void displayWelcomeMessage(int consoleWidth, PrintWriter writer) {
        String[] lines = new String[]{"", "===========================================", "=       _              _ ____  ____       =", "=      | | _____  __ _| |  _ \\| __ )      =", "=      | |/ / __|/ _` | | | | |  _ \\      =", "=      |   <\\__ \\ (_| | | |_| | |_) |     =", "=      |_|\\_\\___/\\__, |_|____/|____/      =", "=                   |_|                   =", "=  Event Streaming Database purpose-built =", "=        for stream processing apps       =", "==========================================="};
        String copyrightMsg = "Copyright 2017-2020 Confluent Inc.";
        Integer logoWidth = Arrays.stream(lines).map(String::length).reduce(0, Math::max);
        if (consoleWidth < logoWidth) {
            writer.println("ksqlDB, Copyright 2017-2020 Confluent Inc.");
        } else {
            int paddingChars = (consoleWidth - logoWidth) / 2;
            String leftPadding = IntStream.range(0, paddingChars).mapToObj(idx -> " ").collect(Collectors.joining());
            Arrays.stream(lines).forEach(line -> writer.println(leftPadding + line));
            writer.println();
            writer.println("Copyright 2017-2020 Confluent Inc.");
        }
        writer.println();
        writer.flush();
    }
}

