/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.SchemaProvider;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@Immutable
public final class KsqlScalarFunction
extends KsqlFunction {
    static final String INTERNAL_PATH = "internal";
    private final Class<? extends Kudf> kudfClass;
    @EffectivelyImmutable
    private final Function<KsqlConfig, Kudf> udfFactory;

    private KsqlScalarFunction(SchemaProvider returnSchemaProvider, ParamType javaReturnType, List<ParameterInfo> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass, Function<KsqlConfig, Kudf> udfFactory, String description, String pathLoadedFrom, boolean isVariadic) {
        super(returnSchemaProvider, javaReturnType, arguments, functionName, description, pathLoadedFrom, isVariadic);
        this.kudfClass = Objects.requireNonNull(kudfClass, "kudfClass");
        this.udfFactory = Objects.requireNonNull(udfFactory, "udfFactory");
    }

    public static KsqlScalarFunction createLegacyBuiltIn(SqlType returnType, List<ParamType> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass) {
        ParamType javaReturnType = SchemaConverters.sqlToFunctionConverter().toFunctionType(returnType);
        List<ParameterInfo> paramInfos = arguments.stream().map(type -> new ParameterInfo("", (ParamType)type, "", false)).collect(Collectors.toList());
        return KsqlScalarFunction.create((i1, i2) -> returnType, javaReturnType, paramInfos, functionName, kudfClass, ksqlConfig -> {
            try {
                return (Kudf)kudfClass.newInstance();
            }
            catch (Exception e) {
                throw new KsqlException("Failed to create instance of kudfClass " + kudfClass + " for function " + functionName, e);
            }
        }, "", INTERNAL_PATH, false);
    }

    public Class<? extends Kudf> getKudfClass() {
        return this.kudfClass;
    }

    static KsqlScalarFunction create(SchemaProvider schemaProvider, ParamType javaReturnType, List<ParameterInfo> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass, Function<KsqlConfig, Kudf> udfFactory, String description, String pathLoadedFrom, boolean isVariadic) {
        return new KsqlScalarFunction(schemaProvider, javaReturnType, arguments, functionName, kudfClass, udfFactory, description, pathLoadedFrom, isVariadic);
    }

    @Override
    public String toString() {
        return "KsqlFunction{, kudfClass=" + this.kudfClass + '}';
    }

    public Kudf newInstance(KsqlConfig ksqlConfig) {
        return this.udfFactory.apply(ksqlConfig);
    }
}

