/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.common.logging.StructuredLogger;
import io.confluent.common.logging.StructuredLoggerFactory;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.logging.processing.ProcessingLoggerImpl;
import java.util.Collection;
import java.util.function.BiFunction;

public class ProcessingLoggerFactoryImpl
implements ProcessingLoggerFactory {
    private final ProcessingLogConfig config;
    private final StructuredLoggerFactory innerFactory;
    private final BiFunction<ProcessingLogConfig, StructuredLogger, ProcessingLogger> loggerFactory;

    ProcessingLoggerFactoryImpl(ProcessingLogConfig config, StructuredLoggerFactory innerFactory) {
        this(config, innerFactory, ProcessingLoggerImpl::new);
    }

    ProcessingLoggerFactoryImpl(ProcessingLogConfig config, StructuredLoggerFactory innerFactory, BiFunction<ProcessingLogConfig, StructuredLogger, ProcessingLogger> loggerFactory) {
        this.config = config;
        this.innerFactory = innerFactory;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public ProcessingLogger getLogger(String name) {
        return this.loggerFactory.apply(this.config, this.innerFactory.getLogger(name));
    }

    @Override
    public Collection<String> getLoggers() {
        return this.innerFactory.getLoggers();
    }
}

