/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.DuplicateColumnException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public final class LogicalSchema {
    private final ImmutableList<Column> columns;

    public static Builder builder() {
        return new Builder(ImmutableList.of());
    }

    private LogicalSchema(ImmutableList<Column> columns) {
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    public Builder asBuilder() {
        return new Builder(this.columns);
    }

    public List<Column> key() {
        return this.byNamespace().get((Object)Column.Namespace.KEY);
    }

    public List<Column> value() {
        return this.byNamespace().get((Object)Column.Namespace.VALUE);
    }

    public List<Column> columns() {
        return this.columns;
    }

    public Optional<Column> findColumn(ColumnName columnName) {
        return this.findColumnMatching(LogicalSchema.withName(columnName));
    }

    public Optional<Column> findValueColumn(ColumnName columnName) {
        return this.findColumnMatching(LogicalSchema.withNamespace(Column.Namespace.VALUE).and(LogicalSchema.withName(columnName)));
    }

    public boolean valueContainsAny(Set<ColumnName> names) {
        return this.value().stream().map(Column::name).anyMatch(names::contains);
    }

    public LogicalSchema withPseudoAndKeyColsInValue(boolean windowed) {
        return this.rebuild(true, windowed);
    }

    public LogicalSchema withoutPseudoAndKeyColsInValue() {
        return this.rebuild(false, false);
    }

    public LogicalSchema withKeyColsOnly() {
        List<Column> key = this.byNamespace().get((Object)Column.Namespace.KEY);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(key);
        int valueIndex = 0;
        for (Column c : key) {
            builder.add((Object)Column.of(c.name(), c.type(), Column.Namespace.VALUE, valueIndex++));
        }
        return new LogicalSchema((ImmutableList<Column>)builder.build());
    }

    public boolean isKeyColumn(ColumnName columnName) {
        return this.findColumnMatching(LogicalSchema.withNamespace(Column.Namespace.KEY).and(LogicalSchema.withName(columnName))).isPresent();
    }

    public boolean compatibleSchema(LogicalSchema other) {
        if (this.columns().size() != other.columns().size()) {
            return false;
        }
        for (int i = 0; i < this.columns().size(); ++i) {
            Column s1Column = this.columns().get(i);
            Column s2Column = other.columns().get(i);
            SqlType s2Type = s2Column.type();
            if (s1Column.equalsIgnoreType(s2Column) && s1Column.canImplicitlyCast(s2Type)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalSchema that = (LogicalSchema)o;
        return Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return this.columns.stream().map(c -> c.toString(formatOptions)).collect(Collectors.joining(", "));
    }

    private Optional<Column> findColumnMatching(Predicate<Column> predicate) {
        return this.columns.stream().filter(predicate).min(Comparator.comparingInt(c -> c.namespace().ordinal()));
    }

    private Map<Column.Namespace, List<Column>> byNamespace() {
        Map<Column.Namespace, List<Column>> byNamespace = this.columns.stream().collect(Collectors.groupingBy(Column::namespace));
        Arrays.stream(Column.Namespace.values()).forEach(ns -> {
            List cfr_ignored_0 = (List)byNamespace.putIfAbsent((Column.Namespace)((Object)ns), (List<Column>)ImmutableList.of());
        });
        return byNamespace;
    }

    private LogicalSchema rebuild(boolean withPseudoAndKeyColsInValue, boolean windowedKey) {
        Map<Column.Namespace, List<Column>> byNamespace = this.byNamespace();
        List<Column> key = byNamespace.get((Object)Column.Namespace.KEY);
        List<Column> value = byNamespace.get((Object)Column.Namespace.VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(key);
        int valueIndex = 0;
        for (Column c : value) {
            if (SystemColumns.isSystemColumn(c.name()) || this.findColumnMatching(LogicalSchema.withNamespace(Column.Namespace.KEY).and(LogicalSchema.withName(c.name()))).isPresent()) continue;
            builder.add((Object)Column.of(c.name(), c.type(), Column.Namespace.VALUE, valueIndex++));
        }
        if (withPseudoAndKeyColsInValue) {
            builder.add((Object)Column.of(SystemColumns.ROWTIME_NAME, SystemColumns.ROWTIME_TYPE, Column.Namespace.VALUE, valueIndex++));
            for (Column c : key) {
                builder.add((Object)Column.of(c.name(), c.type(), Column.Namespace.VALUE, valueIndex++));
            }
            if (windowedKey) {
                builder.add((Object)Column.of(SystemColumns.WINDOWSTART_NAME, SystemColumns.WINDOWBOUND_TYPE, Column.Namespace.VALUE, valueIndex++));
                builder.add((Object)Column.of(SystemColumns.WINDOWEND_NAME, SystemColumns.WINDOWBOUND_TYPE, Column.Namespace.VALUE, valueIndex));
            }
        }
        return new LogicalSchema((ImmutableList<Column>)builder.build());
    }

    private static Predicate<Column> withName(ColumnName name) {
        return c -> c.name().equals(name);
    }

    private static Predicate<Column> withNamespace(Column.Namespace ns) {
        return c -> c.namespace() == ns;
    }

    public static final class Builder {
        private final ImmutableList.Builder<Column> columns = ImmutableList.builder();
        private final Set<ColumnName> seenKeys = new HashSet<ColumnName>();
        private final Set<ColumnName> seenValues = new HashSet<ColumnName>();

        private Builder(ImmutableList<Column> columns) {
            columns.forEach(col -> {
                if (col.namespace() == Column.Namespace.KEY) {
                    this.keyColumn(col.name(), col.type());
                } else {
                    this.valueColumn(col.name(), col.type());
                }
            });
        }

        public Builder keyColumns(Iterable<? extends SimpleColumn> columns) {
            columns.forEach(this::keyColumn);
            return this;
        }

        public Builder keyColumn(ColumnName columnName, SqlType type) {
            this.addColumn(Column.of(columnName, type, Column.Namespace.KEY, this.seenKeys.size()));
            return this;
        }

        public Builder keyColumn(SimpleColumn col) {
            return this.keyColumn(col.name(), col.type());
        }

        public Builder valueColumns(Iterable<? extends SimpleColumn> column) {
            column.forEach(this::valueColumn);
            return this;
        }

        public Builder valueColumn(SimpleColumn col) {
            return this.valueColumn(col.name(), col.type());
        }

        public Builder valueColumn(ColumnName name, SqlType type) {
            this.addColumn(Column.of(name, type, Column.Namespace.VALUE, this.seenValues.size()));
            return this;
        }

        public LogicalSchema build() {
            return new LogicalSchema(this.columns.build());
        }

        private void addColumn(Column column) {
            switch (column.namespace()) {
                case KEY: {
                    if (this.seenKeys.add(column.name())) break;
                    throw new DuplicateColumnException(column.namespace(), column);
                }
                case VALUE: {
                    if (this.seenValues.add(column.name())) break;
                    throw new DuplicateColumnException(column.namespace(), column);
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + column);
                }
            }
            this.columns.add((Object)column);
        }
    }
}

