/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppInfo {
    private static final Logger log;
    private static String version;
    private static String commitId;

    private AppInfo() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getCommitId() {
        return commitId;
    }

    public static void main(String[] args) {
        System.err.println(AppInfo.getVersion());
        System.err.println(AppInfo.getCommitId());
    }

    static {
        Throwable throwable;
        InputStream resourceAsStream;
        Properties props;
        log = LoggerFactory.getLogger(AppInfo.class);
        version = "unknown";
        commitId = "unknown";
        try {
            props = new Properties();
            resourceAsStream = AppInfo.class.getResourceAsStream("/version.properties");
            throwable = null;
            try {
                props.load(resourceAsStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resourceAsStream != null) {
                    if (throwable != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resourceAsStream.close();
                    }
                }
            }
            version = props.getProperty("version", version).trim();
        }
        catch (Exception e) {
            log.warn("Error while loading version:", (Throwable)e);
        }
        try {
            props = new Properties();
            resourceAsStream = AppInfo.class.getResourceAsStream("/git.properties");
            throwable = null;
            try {
                props.load(resourceAsStream);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (resourceAsStream != null) {
                    if (throwable != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        resourceAsStream.close();
                    }
                }
            }
            commitId = props.getProperty("git.commit.id", commitId).trim();
        }
        catch (Exception e) {
            log.warn("Error while loading git properties:", (Throwable)e);
        }
    }
}

