/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    private RetryUtil() {
    }

    public static void retryWithBackoff(int maxRetries, int initialWaitMs, int maxWaitMs, Runnable runnable, Class<?> ... passThroughExceptions) {
        RetryUtil.retryWithBackoff(maxRetries, initialWaitMs, maxWaitMs, runnable, () -> false, Arrays.stream(passThroughExceptions).map(c -> c::isInstance).collect(Collectors.toList()));
    }

    public static void retryWithBackoff(int maxRetries, int initialWaitMs, int maxWaitMs, Runnable runnable, Supplier<Boolean> stopRetrying, List<Predicate<Exception>> passThroughExceptions) {
        RetryUtil.retryWithBackoff(maxRetries, initialWaitMs, maxWaitMs, runnable, (Long duration) -> {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                log.debug("retryWithBackoff interrupted while sleeping");
            }
        }, stopRetrying, passThroughExceptions);
    }

    static void retryWithBackoff(int maxRetries, int initialWaitMs, int maxWaitMs, Runnable runnable, Consumer<Long> sleep, Supplier<Boolean> stopRetrying, List<Predicate<Exception>> passThroughExceptions) {
        long wait = initialWaitMs;
        int i = 0;
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException exception) {
                passThroughExceptions.stream().filter(pte -> pte.test(exception)).findFirst().ifPresent(e -> {
                    throw exception;
                });
                if (++i > maxRetries) {
                    throw exception;
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                log.error("Exception encountered running command: {}. Retrying in {} ms", (Object)exception.getMessage(), (Object)wait);
                log.error("Stack trace: " + stringWriter.toString());
                sleep.accept(wait);
                long l = wait = wait * 2L > (long)maxWaitMs ? (long)maxWaitMs : wait * 2L;
                if (!stopRetrying.get().booleanValue()) continue;
                log.info("Stopping retries");
                throw exception;
            }
            break;
        }
    }
}

