/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.PartialStringToTimestampParser;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;

public final class SqlTimeTypes {
    private static PartialStringToTimestampParser PARSER = new PartialStringToTimestampParser();
    private static final String TIME_HELP_MESSAGE = System.lineSeparator() + "Required format is: \"" + "HH:mm:ss.SSS" + "\", for example: '01:34:20.123' or '01:34:20'. Partials are also supported, for example '01:34'";
    private static final String DATE_HELP_MESSAGE = System.lineSeparator() + "Required format is: \"" + "yyyy-MM-dd" + "\", for example '2020-05-26'. Partials are also supported, for example '2020-05'";

    private SqlTimeTypes() {
    }

    public static Timestamp parseTimestamp(String str) {
        return PARSER.parseToTimestamp(str);
    }

    public static String formatTimestamp(Timestamp timestamp) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(ZoneId.of("Z")).format(timestamp.toInstant());
    }

    public static Time parseTime(String str) {
        try {
            return new Time(LocalTime.parse(str).toNanoOfDay() / 1000000L);
        }
        catch (DateTimeParseException e) {
            throw new KsqlException("Failed to parse time '" + str + "': " + e.getMessage() + TIME_HELP_MESSAGE, (Throwable)e);
        }
    }

    public static String formatTime(Time time) {
        return LocalTime.ofSecondOfDay(time.getTime() / 1000L).toString();
    }

    public static Date parseDate(String str) {
        try {
            return new Date(TimeUnit.DAYS.toMillis(LocalDate.parse(PartialStringToTimestampParser.completeDate((String)str)).toEpochDay()));
        }
        catch (DateTimeParseException e) {
            throw new KsqlException("Failed to parse date '" + str + "': " + e.getMessage() + DATE_HELP_MESSAGE, (Throwable)e);
        }
    }

    public static String formatDate(Date date) {
        return LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(date.getTime())).toString();
    }

    public static Date timestampToDate(Timestamp timestamp) {
        long epochDay = timestamp.toInstant().atZone(ZoneId.of("Z")).toLocalDate().toEpochDay();
        return new Date(TimeUnit.DAYS.toMillis(epochDay));
    }

    public static Time timestampToTime(Timestamp timestamp) {
        long nanoOfDay = timestamp.toInstant().atZone(ZoneId.of("Z")).toLocalTime().toNanoOfDay();
        return new Time(TimeUnit.NANOSECONDS.toMillis(nanoOfDay));
    }
}

