/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface SqlValueCoercer {
    public Result coerce(Object var1, SqlType var2);

    public static class Result {
        private final Optional<Optional<?>> result;

        public static Result failure() {
            return new Result(Optional.empty());
        }

        public static Result nullResult() {
            return new Result(Optional.of(Optional.empty()));
        }

        public static Result of(Object result) {
            return new Result(Optional.of(Optional.of(result)));
        }

        private Result(Optional<Optional<?>> result) {
            this.result = result;
        }

        public boolean failed() {
            return !this.result.isPresent();
        }

        public Optional<?> value() {
            return this.result.orElseThrow(IllegalStateException::new);
        }

        public <X extends Throwable> Optional<?> orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            return this.result.orElseThrow(exceptionSupplier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result1 = (Result)o;
            return Objects.equals(this.result, result1.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }

        public String toString() {
            return "Result(" + this.result.orElse(Optional.of("FAILED")).map(Objects::toString).orElse("null") + ')';
        }
    }
}

