/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.codegen.CodeGenSpec;
import io.confluent.ksql.execution.codegen.helpers.ArrayAccess;
import io.confluent.ksql.execution.codegen.helpers.ArrayBuilder;
import io.confluent.ksql.execution.codegen.helpers.CastEvaluator;
import io.confluent.ksql.execution.codegen.helpers.InListEvaluator;
import io.confluent.ksql.execution.codegen.helpers.LambdaUtil;
import io.confluent.ksql.execution.codegen.helpers.LikeEvaluator;
import io.confluent.ksql.execution.codegen.helpers.MapBuilder;
import io.confluent.ksql.execution.codegen.helpers.NullSafe;
import io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction;
import io.confluent.ksql.execution.codegen.helpers.TriFunction;
import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.IntervalUnit;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaVariable;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TimeLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import io.confluent.ksql.execution.util.CoercionUtil;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.execution.util.FunctionArgumentsUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.Operator;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBooleans;
import io.confluent.ksql.schema.ksql.SqlDoubles;
import io.confluent.ksql.schema.ksql.SqlTimestamps;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class SqlToJavaVisitor {
    public static final List<String> JAVA_IMPORTS = ImmutableList.of((Object)"io.confluent.ksql.execution.codegen.helpers.ArrayAccess", (Object)"io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction", (Object)"io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction.LazyWhenClause", (Object)"java.util.concurrent.TimeUnit", (Object)"java.sql.Timestamp", (Object)"java.util.Arrays", (Object)"java.util.HashMap", (Object)"java.util.Map", (Object)"java.util.List", (Object)"java.util.Objects", (Object)"java.util.ArrayList", (Object)"com.google.common.collect.ImmutableList", (Object[])new String[]{"com.google.common.collect.ImmutableMap", "java.util.function.Supplier", Function.class.getCanonicalName(), BiFunction.class.getCanonicalName(), TriFunction.class.getCanonicalName(), DecimalUtil.class.getCanonicalName(), BigDecimal.class.getCanonicalName(), MathContext.class.getCanonicalName(), RoundingMode.class.getCanonicalName(), SchemaBuilder.class.getCanonicalName(), Struct.class.getCanonicalName(), ArrayBuilder.class.getCanonicalName(), LikeEvaluator.class.getCanonicalName(), MapBuilder.class.getCanonicalName(), CastEvaluator.class.getCanonicalName(), NullSafe.class.getCanonicalName(), SqlTypes.class.getCanonicalName(), SchemaConverters.class.getCanonicalName(), InListEvaluator.class.getCanonicalName(), SqlDoubles.class.getCanonicalName(), SqlBooleans.class.getCanonicalName(), SqlTimestamps.class.getCanonicalName()});
    private static final Map<Operator, String> DECIMAL_OPERATOR_NAME = ImmutableMap.builder().put((Object)Operator.ADD, (Object)"add").put((Object)Operator.SUBTRACT, (Object)"subtract").put((Object)Operator.MULTIPLY, (Object)"multiply").put((Object)Operator.DIVIDE, (Object)"divide").put((Object)Operator.MODULUS, (Object)"remainder").build();
    private static final Map<ComparisonExpression.Type, String> SQL_COMPARE_TO_JAVA = ImmutableMap.builder().put((Object)ComparisonExpression.Type.EQUAL, (Object)"==").put((Object)ComparisonExpression.Type.NOT_EQUAL, (Object)"!=").put((Object)ComparisonExpression.Type.IS_DISTINCT_FROM, (Object)"!=").put((Object)ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Object)">=").put((Object)ComparisonExpression.Type.GREATER_THAN, (Object)">").put((Object)ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Object)"<=").put((Object)ComparisonExpression.Type.LESS_THAN, (Object)"<").build();
    private final LogicalSchema schema;
    private final FunctionRegistry functionRegistry;
    private final ExpressionTypeManager expressionTypeManager;
    private final Function<FunctionName, String> funNameToCodeName;
    private final Function<ColumnName, String> colRefToCodeName;
    private final Function<CreateStructExpression, String> structToCodeName;
    private final KsqlConfig ksqlConfig;

    public static SqlToJavaVisitor of(LogicalSchema schema, FunctionRegistry functionRegistry, CodeGenSpec spec, KsqlConfig ksqlConfig) {
        HashMultiset nameCounts = HashMultiset.create();
        return new SqlToJavaVisitor(schema, functionRegistry, spec::getCodeName, arg_0 -> SqlToJavaVisitor.lambda$of$0((Multiset)nameCounts, spec, arg_0), spec::getStructSchemaName, ksqlConfig);
    }

    @VisibleForTesting
    SqlToJavaVisitor(LogicalSchema schema, FunctionRegistry functionRegistry, Function<ColumnName, String> colRefToCodeName, Function<FunctionName, String> funNameToCodeName, Function<CreateStructExpression, String> structToCodeName, KsqlConfig ksqlConfig) {
        this.expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.colRefToCodeName = Objects.requireNonNull(colRefToCodeName, "colRefToCodeName");
        this.funNameToCodeName = Objects.requireNonNull(funNameToCodeName, "funNameToCodeName");
        this.structToCodeName = Objects.requireNonNull(structToCodeName, "structToCodeName");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
    }

    public String process(Expression expression) {
        return this.formatExpression(expression);
    }

    private String formatExpression(Expression expression) {
        Context context = new Context();
        Pair expressionFormatterResult = (Pair)new Formatter(this.functionRegistry).process(expression, context);
        return (String)expressionFormatterResult.getLeft();
    }

    private static /* synthetic */ String lambda$of$0(Multiset nameCounts, CodeGenSpec spec, FunctionName name) {
        int index = nameCounts.add((Object)name, 1);
        return spec.getUniqueNameForFunction(name, index);
    }

    private static final class CaseWhenProcessed {
        private final Pair<String, SqlType> whenProcessResult;
        private final Pair<String, SqlType> thenProcessResult;

        private CaseWhenProcessed(Pair<String, SqlType> whenProcessResult, Pair<String, SqlType> thenProcessResult) {
            this.whenProcessResult = whenProcessResult;
            this.thenProcessResult = thenProcessResult;
        }
    }

    private class Formatter
    implements ExpressionVisitor<Pair<String, SqlType>, Context> {
        private final FunctionRegistry functionRegistry;

        Formatter(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
        }

        private Pair<String, SqlType> visitIllegalState(Expression expression) {
            throw new IllegalStateException(String.format("expression type %s should never be visited", ((Object)((Object)expression)).getClass()));
        }

        private Pair<String, SqlType> visitUnsupported(Expression expression) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), ((Object)((Object)expression)).getClass().getSimpleName()));
        }

        @Override
        public Pair<String, SqlType> visitType(Type node, Context context) {
            return this.visitIllegalState(node);
        }

        @Override
        public Pair<String, SqlType> visitWhenClause(WhenClause whenClause, Context context) {
            return this.visitIllegalState(whenClause);
        }

        @Override
        public Pair<String, SqlType> visitInPredicate(InPredicate inPredicate, Context context) {
            InPredicate preprocessed = InListEvaluator.preprocess(inPredicate, SqlToJavaVisitor.this.expressionTypeManager, context.getLambdaSqlTypeMapping());
            Pair value = (Pair)this.process(preprocessed.getValue(), context);
            String values = preprocessed.getValueList().getValues().stream().map(v -> (Pair)this.process((Expression)((Object)v), context)).map(Pair::getLeft).collect(Collectors.joining(","));
            return new Pair((Object)("InListEvaluator.matches(" + (String)value.getLeft() + "," + values + ")"), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitInListExpression(InListExpression inListExpression, Context context) {
            return this.visitUnsupported(inListExpression);
        }

        @Override
        public Pair<String, SqlType> visitTimestampLiteral(TimestampLiteral node, Context context) {
            return new Pair((Object)node.toString(), (Object)SqlTypes.TIMESTAMP);
        }

        @Override
        public Pair<String, SqlType> visitTimeLiteral(TimeLiteral timeLiteral, Context context) {
            return this.visitUnsupported(timeLiteral);
        }

        @Override
        public Pair<String, SqlType> visitSimpleCaseExpression(SimpleCaseExpression simpleCaseExpression, Context context) {
            return this.visitUnsupported(simpleCaseExpression);
        }

        @Override
        public Pair<String, SqlType> visitBooleanLiteral(BooleanLiteral node, Context context) {
            return new Pair((Object)String.valueOf(node.getValue()), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitStringLiteral(StringLiteral node, Context context) {
            return new Pair((Object)("\"" + StringEscapeUtils.escapeJava((String)node.getValue()) + "\""), (Object)SqlTypes.STRING);
        }

        @Override
        public Pair<String, SqlType> visitDoubleLiteral(DoubleLiteral node, Context context) {
            return new Pair((Object)node.toString(), (Object)SqlTypes.DOUBLE);
        }

        @Override
        public Pair<String, SqlType> visitDecimalLiteral(DecimalLiteral decimalLiteral, Context context) {
            return new Pair((Object)("new BigDecimal(\"" + decimalLiteral.getValue() + "\")"), (Object)DecimalUtil.fromValue((BigDecimal)decimalLiteral.getValue()));
        }

        @Override
        public Pair<String, SqlType> visitNullLiteral(NullLiteral node, Context context) {
            return new Pair((Object)"null", null);
        }

        @Override
        public Pair<String, SqlType> visitLambdaExpression(LambdaFunctionCall lambdaFunctionCall, Context context) {
            Pair lambdaBody = (Pair)this.process(lambdaFunctionCall.getBody(), context);
            ArrayList argPairs = new ArrayList();
            for (String lambdaArg : lambdaFunctionCall.getArguments()) {
                argPairs.add(new Pair((Object)lambdaArg, (Object)SchemaConverters.sqlToJavaConverter().toJavaType(context.getLambdaSqlTypeMapping().get(lambdaArg))));
            }
            return new Pair((Object)LambdaUtil.toJavaCode(argPairs, (String)lambdaBody.getLeft()), null);
        }

        @Override
        public Pair<String, SqlType> visitLambdaVariable(LambdaVariable lambdaVariable, Context context) {
            return new Pair((Object)lambdaVariable.getLambdaCharacter(), (Object)context.getLambdaSqlTypeMapping().get(lambdaVariable.getLambdaCharacter()));
        }

        @Override
        public Pair<String, SqlType> visitIntervalUnit(IntervalUnit exp, Context context) {
            return new Pair((Object)("TimeUnit." + exp.getUnit().toString()), null);
        }

        @Override
        public Pair<String, SqlType> visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Context context) {
            ColumnName fieldName = node.getColumnName();
            Column schemaColumn = (Column)SqlToJavaVisitor.this.schema.findValueColumn(node.getColumnName()).orElseThrow(() -> new KsqlException("Field not found: " + node.getColumnName()));
            return new Pair(SqlToJavaVisitor.this.colRefToCodeName.apply(fieldName), (Object)schemaColumn.type());
        }

        @Override
        public Pair<String, SqlType> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Context context) {
            throw new UnsupportedOperationException("Qualified column reference must be resolved to unqualified reference before codegen");
        }

        @Override
        public Pair<String, SqlType> visitDereferenceExpression(DereferenceExpression node, Context context) {
            SqlType functionReturnSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node, context.getLambdaSqlTypeMapping());
            String javaReturnType = SchemaConverters.sqlToJavaConverter().toJavaType(functionReturnSchema).getSimpleName();
            String struct = (String)((Pair)this.process(node.getBase(), context)).getLeft();
            String field = (String)((Pair)this.process(new StringLiteral(node.getFieldName()), context)).getLeft();
            String codeString = "((" + javaReturnType + ") " + struct + ".get(" + field + "))";
            return new Pair((Object)codeString, (Object)functionReturnSchema);
        }

        @Override
        public Pair<String, SqlType> visitLongLiteral(LongLiteral node, Context context) {
            return new Pair((Object)(node.getValue() + "L"), (Object)SqlTypes.BIGINT);
        }

        @Override
        public Pair<String, SqlType> visitIntegerLiteral(IntegerLiteral node, Context context) {
            return new Pair((Object)Integer.toString(node.getValue()), (Object)SqlTypes.INTEGER);
        }

        @Override
        public Pair<String, SqlType> visitFunctionCall(FunctionCall node, Context context) {
            FunctionName functionName = node.getName();
            String instanceName = (String)SqlToJavaVisitor.this.funNameToCodeName.apply(functionName);
            UdfFactory udfFactory = this.functionRegistry.getUdfFactory(node.getName());
            FunctionArgumentsUtil.FunctionTypeInfo argumentsAndContext = FunctionArgumentsUtil.getFunctionTypeInfo(SqlToJavaVisitor.this.expressionTypeManager, node, udfFactory, context.getLambdaSqlTypeMapping());
            SqlType returnType = argumentsAndContext.getReturnType();
            String javaReturnType = SchemaConverters.sqlToJavaConverter().toJavaType(returnType).getSimpleName();
            List<Expression> arguments = node.getArguments();
            List<FunctionArgumentsUtil.ArgumentInfo> argumentInfos = argumentsAndContext.getArgumentInfos();
            KsqlScalarFunction function = argumentsAndContext.getFunction();
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < arguments.size(); ++i) {
                Expression arg = arguments.get(i);
                SqlType sqlType = argumentInfos.get(i).getSqlArgument().getSqlType().orElse(null);
                ParamType paramType = i >= function.parameters().size() - 1 && function.isVariadic() ? ((ArrayType)Iterables.getLast((Iterable)function.parameters())).element() : (ParamType)function.parameters().get(i);
                joiner.add((CharSequence)((Pair)this.process(this.convertArgument(arg, sqlType, paramType), new Context(argumentInfos.get(i).getLambdaSqlTypeMapping()))).getLeft());
            }
            String argumentsString = joiner.toString();
            String codeString = "((" + javaReturnType + ") " + instanceName + ".evaluate(" + argumentsString + "))";
            return new Pair((Object)codeString, (Object)returnType);
        }

        private Expression convertArgument(Expression argument, SqlType argType, ParamType funType) {
            if (argType == null || GenericsUtil.hasGenerics((ParamType)funType) || SchemaConverters.sqlToFunctionConverter().toFunctionType(argType).equals((Object)funType)) {
                return argument;
            }
            SqlDecimal target = funType == ParamTypes.DECIMAL ? DecimalUtil.toSqlDecimal((SqlType)argType) : SchemaConverters.functionToSqlConverter().toSqlType(funType);
            return new Cast(argument, new Type((SqlType)target));
        }

        @Override
        public Pair<String, SqlType> visitLogicalBinaryExpression(LogicalBinaryExpression node, Context context) {
            if (node.getType() == LogicalBinaryExpression.Type.OR) {
                return new Pair((Object)this.formatBinaryExpression(" || ", node.getLeft(), node.getRight(), context), (Object)SqlTypes.BOOLEAN);
            }
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                return new Pair((Object)this.formatBinaryExpression(" && ", node.getLeft(), node.getRight(), context), (Object)SqlTypes.BOOLEAN);
            }
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), ((Object)((Object)node)).getClass().getSimpleName()));
        }

        @Override
        public Pair<String, SqlType> visitNotExpression(NotExpression node, Context context) {
            String exprString = (String)((Pair)this.process(node.getValue(), context)).getLeft();
            return new Pair((Object)("(!" + exprString + ")"), (Object)SqlTypes.BOOLEAN);
        }

        private String nullCheckPrefix(ComparisonExpression.Type type) {
            if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) {
                return "(((Object)(%1$s)) == null || ((Object)(%2$s)) == null) ? ((((Object)(%1$s)) == null ) ^ (((Object)(%2$s)) == null )) : ";
            }
            return "(((Object)(%1$s)) == null || ((Object)(%2$s)) == null) ? false : ";
        }

        private String visitStringComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(!%1$s.equals(%2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s.compareTo(%2$s) " + type.getValue() + " 0)";
                }
            }
            throw new KsqlException("Unexpected string comparison: " + type.getValue());
        }

        private String visitArrayComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(!%1$s.equals(%2$s))";
                }
            }
            throw new KsqlException("Unexpected array comparison: " + type.getValue());
        }

        private String visitMapComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(!%1$s.equals(%2$s))";
                }
            }
            throw new KsqlException("Unexpected map comparison: " + type.getValue());
        }

        private String visitStructComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(%1$s.equals(%2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(!%1$s.equals(%2$s))";
                }
            }
            throw new KsqlException("Unexpected struct comparison: " + type.getValue());
        }

        private String visitScalarComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "((%1$s <= %2$s) && (%1$s >= %2$s))";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "((%1$s < %2$s) || (%1$s > %2$s))";
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    return "(%1$s " + type.getValue() + " %2$s)";
                }
            }
            throw new KsqlException("Unexpected scalar comparison: " + type.getValue());
        }

        private String visitBytesComparisonExpression(ComparisonExpression.Type type, SqlType left, SqlType right) {
            String comparator = (String)SQL_COMPARE_TO_JAVA.get((Object)type);
            if (comparator == null) {
                throw new KsqlException("Unexpected scalar comparison: " + type.getValue());
            }
            return String.format("(%s.compareTo(%s) %s 0)", this.toDecimal(left, 1), this.toDecimal(right, 2), comparator);
        }

        private String toDecimal(SqlType schema, int index) {
            switch (schema.baseType()) {
                case DECIMAL: {
                    return "%" + index + "$s";
                }
                case DOUBLE: {
                    return "BigDecimal.valueOf(%" + index + "$s)";
                }
            }
            return "new BigDecimal(%" + index + "$s)";
        }

        private String visitBooleanComparisonExpression(ComparisonExpression.Type type) {
            switch (type) {
                case EQUAL: {
                    return "(Boolean.compare(%1$s, %2$s) == 0)";
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return "(Boolean.compare(%1$s, %2$s) != 0)";
                }
            }
            throw new KsqlException("Unexpected boolean comparison: " + type.getValue());
        }

        private String visitTimestampComparisonExpression(ComparisonExpression.Type type, SqlType left, SqlType right) {
            String comparator = (String)SQL_COMPARE_TO_JAVA.get((Object)type);
            if (comparator == null) {
                throw new KsqlException("Unexpected timestamp comparison: " + type.getValue());
            }
            return String.format("(%s.compareTo(%s) %s 0)", this.toTimestamp(left, 1), this.toTimestamp(right, 2), comparator);
        }

        private String toTimestamp(SqlType schema, int index) {
            switch (schema.baseType()) {
                case TIMESTAMP: {
                    return "%" + index + "$s";
                }
                case STRING: {
                    return "SqlTimestamps.parseTimestamp(%" + index + "$s)";
                }
            }
            throw new KsqlException("Unexpected comparison to TIMESTAMP: " + schema.baseType());
        }

        @Override
        public Pair<String, SqlType> visitComparisonExpression(ComparisonExpression node, Context context) {
            Pair left = (Pair)this.process(node.getLeft(), context);
            Pair right = (Pair)this.process(node.getRight(), context);
            String exprFormat = this.nullCheckPrefix(node.getType());
            if (((SqlType)left.getRight()).baseType() == SqlBaseType.DECIMAL || ((SqlType)right.getRight()).baseType() == SqlBaseType.DECIMAL) {
                exprFormat = exprFormat + this.visitBytesComparisonExpression(node.getType(), (SqlType)left.getRight(), (SqlType)right.getRight());
            } else if (((SqlType)left.getRight()).baseType() == SqlBaseType.TIMESTAMP || ((SqlType)right.getRight()).baseType() == SqlBaseType.TIMESTAMP) {
                exprFormat = exprFormat + this.visitTimestampComparisonExpression(node.getType(), (SqlType)left.getRight(), (SqlType)right.getRight());
            } else {
                switch (((SqlType)left.getRight()).baseType()) {
                    case STRING: {
                        exprFormat = exprFormat + this.visitStringComparisonExpression(node.getType());
                        break;
                    }
                    case ARRAY: {
                        exprFormat = exprFormat + this.visitArrayComparisonExpression(node.getType());
                        break;
                    }
                    case MAP: {
                        exprFormat = exprFormat + this.visitMapComparisonExpression(node.getType());
                        break;
                    }
                    case STRUCT: {
                        exprFormat = exprFormat + this.visitStructComparisonExpression(node.getType());
                        break;
                    }
                    case BOOLEAN: {
                        exprFormat = exprFormat + this.visitBooleanComparisonExpression(node.getType());
                        break;
                    }
                    default: {
                        exprFormat = exprFormat + this.visitScalarComparisonExpression(node.getType());
                    }
                }
            }
            String expr = "(" + String.format(exprFormat, left.getLeft(), right.getLeft()) + ")";
            return new Pair((Object)expr, (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitCast(Cast node, Context context) {
            Pair expr = (Pair)this.process(node.getExpression(), context);
            SqlType to = node.getType().getSqlType();
            return Pair.of((Object)this.genCastCode((Pair<String, SqlType>)expr, to), (Object)to);
        }

        @Override
        public Pair<String, SqlType> visitIsNullPredicate(IsNullPredicate node, Context context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            return new Pair((Object)("((" + (String)value.getLeft() + ") == null )"), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            return new Pair((Object)("((" + (String)value.getLeft() + ") != null )"), (Object)SqlTypes.BOOLEAN);
        }

        @Override
        public Pair<String, SqlType> visitArithmeticUnary(ArithmeticUnaryExpression node, Context context) {
            Pair value = (Pair)this.process(node.getValue(), context);
            switch (node.getSign()) {
                case MINUS: {
                    return this.visitArithmeticMinus((Pair<String, SqlType>)value);
                }
                case PLUS: {
                    return this.visitArithmeticPlus((Pair<String, SqlType>)value);
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + (Object)((Object)node.getSign()));
        }

        private Pair<String, SqlType> visitArithmeticMinus(Pair<String, SqlType> value) {
            if (((SqlType)value.getRight()).baseType() == SqlBaseType.DECIMAL) {
                return new Pair((Object)String.format("(%s.negate(new MathContext(%d, RoundingMode.UNNECESSARY)))", value.getLeft(), ((SqlDecimal)value.getRight()).getPrecision()), value.getRight());
            }
            String separator = ((String)value.getLeft()).startsWith("-") ? " " : "";
            return new Pair((Object)("-" + separator + (String)value.getLeft()), value.getRight());
        }

        private Pair<String, SqlType> visitArithmeticPlus(Pair<String, SqlType> value) {
            if (((SqlType)value.getRight()).baseType() == SqlBaseType.DECIMAL) {
                return new Pair((Object)String.format("(%s.plus(new MathContext(%d, RoundingMode.UNNECESSARY)))", value.getLeft(), ((SqlDecimal)value.getRight()).getPrecision()), value.getRight());
            }
            return new Pair((Object)("+" + (String)value.getLeft()), value.getRight());
        }

        @Override
        public Pair<String, SqlType> visitArithmeticBinary(ArithmeticBinaryExpression node, Context context) {
            Pair left = (Pair)this.process(node.getLeft(), context);
            Pair right = (Pair)this.process(node.getRight(), context);
            SqlType schema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node, context.getLambdaSqlTypeMapping());
            if (schema.baseType() == SqlBaseType.DECIMAL) {
                SqlDecimal decimal = (SqlDecimal)schema;
                String leftExpr = this.genCastCode((Pair<String, SqlType>)left, (SqlType)DecimalUtil.toSqlDecimal((SqlType)((SqlType)left.right)));
                String rightExpr = this.genCastCode((Pair<String, SqlType>)right, (SqlType)DecimalUtil.toSqlDecimal((SqlType)((SqlType)right.right)));
                return new Pair((Object)String.format("(%s.%s(%s, new MathContext(%d, RoundingMode.UNNECESSARY)).setScale(%d))", leftExpr, DECIMAL_OPERATOR_NAME.get(node.getOperator()), rightExpr, decimal.getPrecision(), decimal.getScale()), (Object)schema);
            }
            String leftExpr = ((SqlType)left.getRight()).baseType() == SqlBaseType.DECIMAL ? this.genCastCode((Pair<String, SqlType>)left, (SqlType)SqlTypes.DOUBLE) : (String)left.getLeft();
            String rightExpr = ((SqlType)right.getRight()).baseType() == SqlBaseType.DECIMAL ? this.genCastCode((Pair<String, SqlType>)right, (SqlType)SqlTypes.DOUBLE) : (String)right.getLeft();
            return new Pair((Object)String.format("(%s %s %s)", leftExpr, node.getOperator().getSymbol(), rightExpr), (Object)schema);
        }

        @Override
        public Pair<String, SqlType> visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
            String functionClassName = SearchedCaseFunction.class.getSimpleName();
            List whenClauses = node.getWhenClauses().stream().map(whenClause -> new CaseWhenProcessed((Pair)this.process(whenClause.getOperand(), context), (Pair)this.process(whenClause.getResult(), context))).collect(Collectors.toList());
            SqlType resultSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node, context.getLambdaSqlTypeMapping());
            String resultSchemaString = SchemaConverters.sqlToJavaConverter().toJavaType(resultSchema).getCanonicalName();
            List lazyWhenClause = whenClauses.stream().map(processedWhenClause -> functionClassName + ".whenClause(" + this.buildSupplierCode("Boolean", (String)((CaseWhenProcessed)processedWhenClause).whenProcessResult.getLeft()) + ", " + this.buildSupplierCode(resultSchemaString, (String)((CaseWhenProcessed)processedWhenClause).thenProcessResult.getLeft()) + ")").collect(Collectors.toList());
            String defaultValue = node.getDefaultValue().isPresent() ? (String)((Pair)this.process(node.getDefaultValue().get(), context)).getLeft() : "null";
            String codeString = "((" + resultSchemaString + ")" + functionClassName + ".searchedCaseFunction(ImmutableList.copyOf(Arrays.asList( " + StringUtils.join(lazyWhenClause, (String)", ") + "))," + this.buildSupplierCode(resultSchemaString, defaultValue) + "))";
            return new Pair((Object)codeString, (Object)resultSchema);
        }

        private String buildSupplierCode(String typeString, String code) {
            return " new " + Supplier.class.getSimpleName() + "<" + typeString + ">() { @Override public " + typeString + " get() { return " + code + "; }}";
        }

        @Override
        public Pair<String, SqlType> visitLikePredicate(LikePredicate node, Context context) {
            String patternString = (String)((Pair)this.process(node.getPattern(), context)).getLeft();
            String valueString = (String)((Pair)this.process(node.getValue(), context)).getLeft();
            if (node.getEscape().isPresent()) {
                return new Pair((Object)("LikeEvaluator.matches(" + valueString + ", " + patternString + ", '" + node.getEscape().get() + "')"), (Object)SqlTypes.STRING);
            }
            return new Pair((Object)("LikeEvaluator.matches(" + valueString + ", " + patternString + ")"), (Object)SqlTypes.STRING);
        }

        @Override
        public Pair<String, SqlType> visitSubscriptExpression(SubscriptExpression node, Context context) {
            SqlType internalSchema = SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node.getBase(), context.getLambdaSqlTypeMapping());
            String internalSchemaJavaType = SchemaConverters.sqlToJavaConverter().toJavaType(internalSchema).getCanonicalName();
            switch (internalSchema.baseType()) {
                case ARRAY: {
                    SqlArray array = (SqlArray)internalSchema;
                    String listName = (String)((Pair)this.process(node.getBase(), context)).getLeft();
                    String suppliedIdx = (String)((Pair)this.process(node.getIndex(), context)).getLeft();
                    String code = String.format("((%s) (%s.arrayAccess((%s) %s, ((int) %s))))", SchemaConverters.sqlToJavaConverter().toJavaType(array.getItemType()).getSimpleName(), ArrayAccess.class.getSimpleName(), internalSchemaJavaType, listName, suppliedIdx);
                    return new Pair((Object)code, (Object)array.getItemType());
                }
                case MAP: {
                    SqlMap map = (SqlMap)internalSchema;
                    return new Pair((Object)String.format("((%s) ((%s)%s).get(%s))", SchemaConverters.sqlToJavaConverter().toJavaType(map.getValueType()).getSimpleName(), internalSchemaJavaType, ((Pair)this.process(node.getBase(), context)).getLeft(), ((Pair)this.process(node.getIndex(), context)).getLeft()), (Object)map.getValueType());
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Pair<String, SqlType> visitCreateArrayExpression(CreateArrayExpression exp, Context context) {
            List<Expression> expressions = CoercionUtil.coerceUserList(exp.getValues(), SqlToJavaVisitor.this.expressionTypeManager, context.getLambdaSqlTypeMapping()).expressions();
            StringBuilder array = new StringBuilder("new ArrayBuilder(");
            array.append(expressions.size());
            array.append(')');
            for (Expression value : expressions) {
                array.append(".add(");
                array.append((String)((Pair)this.process(value, context)).getLeft());
                array.append(")");
            }
            return new Pair((Object)("((List)" + array.toString() + ".build())"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(exp, context.getLambdaSqlTypeMapping()));
        }

        @Override
        public Pair<String, SqlType> visitCreateMapExpression(CreateMapExpression exp, Context context) {
            ImmutableMap<Expression, Expression> map = exp.getMap();
            List<Expression> keys = CoercionUtil.coerceUserList((Collection<Expression>)map.keySet(), SqlToJavaVisitor.this.expressionTypeManager, context.getLambdaSqlTypeMapping()).expressions();
            List<Expression> values = CoercionUtil.coerceUserList((Collection<Expression>)map.values(), SqlToJavaVisitor.this.expressionTypeManager, context.getLambdaSqlTypeMapping()).expressions();
            String entries = Streams.zip(keys.stream(), values.stream(), (k, v) -> ".put(" + (String)((Pair)this.process((Expression)((Object)k), context)).getLeft() + ", " + (String)((Pair)this.process((Expression)((Object)v), context)).getLeft() + ")").collect(Collectors.joining());
            return new Pair((Object)("((Map)new MapBuilder(" + map.size() + ")" + entries + ".build())"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(exp, context.getLambdaSqlTypeMapping()));
        }

        @Override
        public Pair<String, SqlType> visitStructExpression(CreateStructExpression node, Context context) {
            String schemaName = (String)SqlToJavaVisitor.this.structToCodeName.apply(node);
            StringBuilder struct = new StringBuilder("new Struct(").append(schemaName).append(")");
            for (CreateStructExpression.Field field : node.getFields()) {
                struct.append(".put(").append('\"').append(field.getName()).append('\"').append(",").append((String)((Pair)this.process(field.getValue(), context)).getLeft()).append(")");
            }
            return new Pair((Object)("((Struct)" + struct.toString() + ")"), (Object)SqlToJavaVisitor.this.expressionTypeManager.getExpressionSqlType(node, context.getLambdaSqlTypeMapping()));
        }

        @Override
        public Pair<String, SqlType> visitBetweenPredicate(BetweenPredicate node, Context context) {
            Pair compareMin = (Pair)this.process(new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), context);
            Pair compareMax = (Pair)this.process(new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax()), context);
            return new Pair((Object)("(" + (String)compareMin.getLeft() + " && " + (String)compareMax.getLeft() + ")"), (Object)SqlTypes.BOOLEAN);
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, Context context) {
            return "(" + (String)((Pair)this.process(left, context)).getLeft() + " " + operator + " " + (String)((Pair)this.process(right, context)).getLeft() + ")";
        }

        private String genCastCode(Pair<String, SqlType> exp, SqlType sqlType) {
            return CastEvaluator.generateCode((String)exp.left, (SqlType)exp.right, sqlType, SqlToJavaVisitor.this.ksqlConfig);
        }
    }

    @Immutable
    private static final class Context {
        private final ImmutableMap<String, SqlType> lambdaSqlTypeMapping;

        private Context() {
            this(new HashMap<String, SqlType>());
        }

        private Context(Map<String, SqlType> mapping) {
            this.lambdaSqlTypeMapping = ImmutableMap.copyOf(mapping);
        }

        Map<String, SqlType> getLambdaSqlTypeMapping() {
            return this.lambdaSqlTypeMapping;
        }
    }
}

