/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import java.util.function.Function;

public final class NullSafe {
    private NullSafe() {
    }

    public static <I, O> O apply(I input, Function<I, O> mapper) {
        return NullSafe.applyOrDefault(input, mapper, null);
    }

    public static <I, O> O applyOrDefault(I input, Function<I, O> mapper, O defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        return mapper.apply(input);
    }

    public static String generateApply(String inputCode, String mapperCode, Class<?> returnType) {
        return "(" + returnType.getSimpleName() + ")" + NullSafe.class.getSimpleName() + ".apply(" + inputCode + "," + mapperCode + ")";
    }

    public static String generateApplyOrDefault(String inputCode, String mapperCode, String defaultValueCode, Class<?> returnType) {
        return "(" + returnType.getSimpleName() + ")" + NullSafe.class.getSimpleName() + ".applyOrDefault(" + inputCode + "," + mapperCode + ", " + defaultValueCode + ")";
    }
}

