/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import io.confluent.ksql.schema.ksql.SqlTypeWalker;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.stream.Collectors;

public final class SqlTypeCodeGen {
    private SqlTypeCodeGen() {
    }

    public static String generateCode(SqlType sqlType) {
        return (String)SqlTypeWalker.visit((SqlType)sqlType, (SqlTypeWalker.Visitor)new TypeVisitor());
    }

    private static class TypeVisitor
    implements SqlTypeWalker.Visitor<String, String> {
        private TypeVisitor() {
        }

        public String visitBoolean(SqlPrimitiveType type) {
            return "SqlTypes.BOOLEAN";
        }

        public String visitInt(SqlPrimitiveType type) {
            return "SqlTypes.INTEGER";
        }

        public String visitBigInt(SqlPrimitiveType type) {
            return "SqlTypes.BIGINT";
        }

        public String visitDouble(SqlPrimitiveType type) {
            return "SqlTypes.DOUBLE";
        }

        public String visitString(SqlPrimitiveType type) {
            return "SqlTypes.STRING";
        }

        public String visitTimestamp(SqlPrimitiveType type) {
            return "SqlTypes.TIMESTAMP";
        }

        public String visitDecimal(SqlDecimal type) {
            return "SqlTypes.decimal(" + type.getPrecision() + "," + type.getScale() + ")";
        }

        public String visitArray(SqlArray type, String element) {
            return "SqlTypes.array(" + element + ")";
        }

        public String visitMap(SqlMap type, String key, String value) {
            return "SqlTypes.map(" + key + "," + value + ")";
        }

        public String visitStruct(SqlStruct type, List<? extends String> fields) {
            return fields.stream().collect(Collectors.joining(").field(", "SqlTypes.struct().field(", ").build()"));
        }

        public String visitField(SqlStruct.Field field, String type) {
            return "\"" + field.name() + "\"," + type;
        }
    }
}

