/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

public abstract class CreateSourceCommand
implements DdlCommand {
    private final SourceName sourceName;
    private final LogicalSchema schema;
    private final Optional<TimestampColumn> timestampColumn;
    private final String topicName;
    private final Formats formats;
    private final Optional<WindowInfo> windowInfo;
    private final Boolean orReplace;

    CreateSourceCommand(SourceName sourceName, LogicalSchema schema, Optional<TimestampColumn> timestampColumn, String topicName, Formats formats, Optional<WindowInfo> windowInfo, Boolean orReplace) {
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
        this.orReplace = orReplace;
        CreateSourceCommand.validate(schema, windowInfo.isPresent());
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Formats getFormats() {
        return this.formats;
    }

    public Optional<WindowInfo> getWindowInfo() {
        return this.windowInfo;
    }

    public Boolean isOrReplace() {
        return this.orReplace;
    }

    private static void validate(LogicalSchema schema, boolean windowed) {
        if (schema.valueContainsAny(SystemColumns.systemColumnNames())) {
            throw new IllegalArgumentException("Schema contains system columns in value schema");
        }
        if (windowed && schema.key().isEmpty()) {
            throw new KsqlException("Windowed sources require a key column.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSourceCommand that = (CreateSourceCommand)o;
        return Objects.equals(this.sourceName, that.sourceName) && Objects.equals(this.schema, that.schema) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.windowInfo, that.windowInfo);
    }

    public int hashCode() {
        return Objects.hash(this.sourceName, this.schema, this.timestampColumn, this.topicName, this.formats, this.windowInfo);
    }
}

