/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class Cast
extends Expression {
    private final Expression expression;
    private final Type type;

    public Cast(Expression expression, Type type) {
        this(Optional.empty(), expression, type);
    }

    public Cast(Optional<NodeLocation> location, Expression expression, Type type) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression");
        this.type = Objects.requireNonNull(type, "type");
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Cast o = (Cast)((Object)obj);
        return Objects.equals((Object)this.expression, (Object)o.expression) && Objects.equals((Object)this.type, (Object)o.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.type});
    }
}

