/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DecimalLiteral
extends Literal {
    private final BigDecimal value;

    public DecimalLiteral(BigDecimal value) {
        this(Optional.empty(), value);
    }

    public DecimalLiteral(Optional<NodeLocation> location, BigDecimal value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitDecimalLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DecimalLiteral that = (DecimalLiteral)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

