/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DereferenceExpression
extends Expression {
    private final Expression base;
    private final String fieldName;

    public DereferenceExpression(Optional<NodeLocation> location, Expression base, String fieldName) {
        super(location);
        this.base = Objects.requireNonNull(base, "base");
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public Expression getBase() {
        return this.base;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)((Object)o);
        return Objects.equals((Object)this.base, (Object)that.base) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.fieldName});
    }
}

