/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class FunctionCall
extends Expression {
    private final FunctionName name;
    private final ImmutableList<Expression> arguments;

    public FunctionCall(FunctionName name, List<Expression> arguments) {
        this(Optional.empty(), name, arguments);
    }

    public FunctionCall(Optional<NodeLocation> location, FunctionName name, List<Expression> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name, "name");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments"));
    }

    public FunctionName getName() {
        return this.name;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public boolean hasLambdaFunctionCallArguments() {
        return this.arguments.stream().anyMatch(argument -> argument instanceof LambdaFunctionCall);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)((Object)obj);
        return Objects.equals(this.name, o.name) && Objects.equals(this.arguments, o.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }
}

