/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.WhenClause;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SimpleCaseExpression
extends Expression {
    private final Expression operand;
    private final ImmutableList<WhenClause> whenClauses;
    private final Optional<Expression> defaultValue;

    public SimpleCaseExpression(Expression operand, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        this(Optional.empty(), operand, whenClauses, defaultValue);
    }

    public SimpleCaseExpression(Optional<NodeLocation> location, Expression operand, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        super(location);
        this.operand = Objects.requireNonNull(operand, "operand");
        this.whenClauses = ImmutableList.copyOf((Collection)Objects.requireNonNull(whenClauses, "whenClauses"));
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public Expression getOperand() {
        return this.operand;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleCaseExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SimpleCaseExpression that = (SimpleCaseExpression)((Object)o);
        return Objects.equals((Object)this.operand, (Object)that.operand) && Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operand, this.whenClauses, this.defaultValue});
    }
}

