/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import io.confluent.ksql.execution.expression.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.execution.expression.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.execution.expression.tree.BetweenPredicate;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.Cast;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.IntervalUnit;
import io.confluent.ksql.execution.expression.tree.IsNotNullPredicate;
import io.confluent.ksql.execution.expression.tree.IsNullPredicate;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaVariable;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.SimpleCaseExpression;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TimeLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.WhenClause;

public abstract class TraversalExpressionVisitor<C>
implements ExpressionVisitor<Void, C> {
    @Override
    public Void visitCast(Cast node, C context) {
        return (Void)this.process(node.getExpression(), context);
    }

    @Override
    public Void visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    public Void visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    public Void visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    public Void visitCreateArrayExpression(CreateArrayExpression exp, C context) {
        exp.getValues().forEach(val -> {
            Void cfr_ignored_0 = (Void)this.process((Expression)((Object)val), context);
        });
        return null;
    }

    @Override
    public Void visitCreateMapExpression(CreateMapExpression exp, C context) {
        exp.getMap().keySet().forEach(key -> {
            Void cfr_ignored_0 = (Void)this.process((Expression)((Object)key), context);
        });
        exp.getMap().values().forEach(val -> {
            Void cfr_ignored_0 = (Void)this.process((Expression)((Object)val), context);
        });
        return null;
    }

    @Override
    public Void visitStructExpression(CreateStructExpression node, C context) {
        node.getFields().forEach(field -> {
            Void cfr_ignored_0 = (Void)this.process(field.getValue(), context);
        });
        return null;
    }

    @Override
    public Void visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    public Void visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    public Void visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    public Void visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaFunctionCall node, C context) {
        this.process(node.getBody(), context);
        return null;
    }

    @Override
    public Void visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public Void visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> {
            Void cfr_ignored_0 = (Void)this.process((Expression)((Object)value), context);
        });
        return null;
    }

    @Override
    public Void visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    public Void visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return (Void)this.process(node.getValue(), context);
    }

    @Override
    public Void visitNotExpression(NotExpression node, C context) {
        return (Void)this.process(node.getValue(), context);
    }

    @Override
    public Void visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> {
            Void cfr_ignored_0 = (Void)this.process((Expression)((Object)value), context);
        });
        return null;
    }

    @Override
    public Void visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        return null;
    }

    @Override
    public Void visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return (Void)this.process(node.getValue(), context);
    }

    @Override
    public Void visitIsNullPredicate(IsNullPredicate node, C context) {
        return (Void)this.process(node.getValue(), context);
    }

    @Override
    public Void visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    public Void visitDoubleLiteral(DoubleLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitDecimalLiteral(DecimalLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitTimeLiteral(TimeLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitTimestampLiteral(TimestampLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitStringLiteral(StringLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitBooleanLiteral(BooleanLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitLambdaVariable(LambdaVariable node, C context) {
        return null;
    }

    @Override
    public Void visitIntervalUnit(IntervalUnit node, C context) {
        return null;
    }

    @Override
    public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, C context) {
        return null;
    }

    @Override
    public Void visitQualifiedColumnReference(QualifiedColumnReferenceExp node, C context) {
        return null;
    }

    @Override
    public Void visitNullLiteral(NullLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitLongLiteral(LongLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitIntegerLiteral(IntegerLiteral node, C context) {
        return null;
    }

    @Override
    public Void visitType(Type node, C context) {
        return null;
    }
}

