/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter;

import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.interpreter.CastInterpreter;
import io.confluent.ksql.execution.interpreter.terms.CastTerm;
import io.confluent.ksql.execution.interpreter.terms.ComparisonTerm;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;

public final class ComparisonInterpreter {
    private ComparisonInterpreter() {
    }

    public static Term doComparison(ComparisonExpression.Type type, Term left, Term right) {
        ComparisonTerm.ComparisonNullCheckFunction nullCheckFunction = ComparisonInterpreter.getNullCheckFunction(type);
        Optional<ComparisonTerm.ComparisonFunction> compareTo = ComparisonInterpreter.doCompareTo(left, right);
        if (compareTo.isPresent()) {
            return new ComparisonTerm.CompareToTerm(left, right, nullCheckFunction, compareTo.get(), ComparisonInterpreter.getComparisonCheckFunction(type, left, right));
        }
        Optional<ComparisonTerm.EqualsFunction> equals = ComparisonInterpreter.doEquals(left, right);
        if (equals.isPresent()) {
            return new ComparisonTerm.EqualsTerm(left, right, nullCheckFunction, equals.get(), ComparisonInterpreter.getEqualsCheckFunction(type, left, right));
        }
        throw new KsqlException("Unsupported comparison between " + left.getSqlType() + " and " + right.getSqlType());
    }

    private static ComparisonTerm.ComparisonNullCheckFunction getNullCheckFunction(ComparisonExpression.Type type) {
        if (type == ComparisonExpression.Type.IS_DISTINCT_FROM) {
            return (leftObject, rightObject) -> {
                if (leftObject == null || rightObject == null) {
                    return Optional.of(leftObject == null ^ rightObject == null);
                }
                return Optional.empty();
            };
        }
        return (leftObject, rightObject) -> {
            if (leftObject == null || rightObject == null) {
                return Optional.of(false);
            }
            return Optional.empty();
        };
    }

    private static Optional<ComparisonTerm.ComparisonFunction> doCompareTo(Term left, Term right) {
        SqlBaseType rightType;
        SqlBaseType leftType = left.getSqlType().baseType();
        if (ComparisonInterpreter.either(leftType, rightType = right.getSqlType().baseType(), SqlBaseType.DECIMAL)) {
            CastTerm.ComparableCastFunction<BigDecimal> castLeft = CastInterpreter.castToBigDecimalFunction(left.getSqlType());
            CastTerm.ComparableCastFunction<BigDecimal> castRight = CastInterpreter.castToBigDecimalFunction(right.getSqlType());
            return Optional.of((o1, o2) -> ((BigDecimal)castLeft.cast(o1)).compareTo((BigDecimal)castRight.cast(o2)));
        }
        if (ComparisonInterpreter.either(leftType, rightType, SqlBaseType.TIMESTAMP)) {
            CastTerm.ComparableCastFunction<Date> castLeft = CastInterpreter.castToTimestampFunction(left.getSqlType());
            CastTerm.ComparableCastFunction<Date> castRight = CastInterpreter.castToTimestampFunction(right.getSqlType());
            return Optional.of((o1, o2) -> ((Date)castLeft.cast(o1)).compareTo((Date)castRight.cast(o2)));
        }
        if (leftType == SqlBaseType.STRING) {
            return Optional.of((o1, o2) -> o1.toString().compareTo(o2.toString()));
        }
        if (ComparisonInterpreter.either(leftType, rightType, SqlBaseType.DOUBLE)) {
            CastTerm.ComparableCastFunction<Double> castLeft = CastInterpreter.castToDoubleFunction(left.getSqlType());
            CastTerm.ComparableCastFunction<Double> castRight = CastInterpreter.castToDoubleFunction(right.getSqlType());
            return Optional.of((o1, o2) -> ((Double)castLeft.cast(o1)).compareTo((Double)castRight.cast(o2)));
        }
        if (ComparisonInterpreter.either(leftType, rightType, SqlBaseType.BIGINT)) {
            CastTerm.ComparableCastFunction<Long> castLeft = CastInterpreter.castToLongFunction(left.getSqlType());
            CastTerm.ComparableCastFunction<Long> castRight = CastInterpreter.castToLongFunction(right.getSqlType());
            return Optional.of((o1, o2) -> ((Long)castLeft.cast(o1)).compareTo((Long)castRight.cast(o2)));
        }
        if (ComparisonInterpreter.either(leftType, rightType, SqlBaseType.INTEGER)) {
            CastTerm.ComparableCastFunction<Integer> castLeft = CastInterpreter.castToIntegerFunction(left.getSqlType());
            CastTerm.ComparableCastFunction<Integer> castRight = CastInterpreter.castToIntegerFunction(right.getSqlType());
            return Optional.of((o1, o2) -> ((Integer)castLeft.cast(o1)).compareTo((Integer)castRight.cast(o2)));
        }
        return Optional.empty();
    }

    private static boolean either(SqlBaseType leftType, SqlBaseType rightType, SqlBaseType value) {
        return leftType == value || rightType == value;
    }

    private static Optional<ComparisonTerm.EqualsFunction> doEquals(Term left, Term right) {
        SqlBaseType leftType = left.getSqlType().baseType();
        switch (leftType) {
            case ARRAY: 
            case MAP: 
            case STRUCT: 
            case BOOLEAN: {
                return Optional.of(Object::equals);
            }
        }
        return Optional.empty();
    }

    private static ComparisonTerm.ComparisonCheckFunction getComparisonCheckFunction(ComparisonExpression.Type type, Term left, Term right) {
        switch (type) {
            case EQUAL: {
                return compareTo -> compareTo == 0;
            }
            case NOT_EQUAL: 
            case IS_DISTINCT_FROM: {
                return compareTo -> compareTo != 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return compareTo -> compareTo >= 0;
            }
            case GREATER_THAN: {
                return compareTo -> compareTo > 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return compareTo -> compareTo <= 0;
            }
            case LESS_THAN: {
                return compareTo -> compareTo < 0;
            }
        }
        throw new KsqlException(String.format("Unsupported comparison between %s and %s: %s", new Object[]{left.getSqlType(), right.getSqlType(), type}));
    }

    private static ComparisonTerm.EqualsCheckFunction getEqualsCheckFunction(ComparisonExpression.Type type, Term left, Term right) {
        switch (type) {
            case EQUAL: {
                return equals -> equals;
            }
            case NOT_EQUAL: 
            case IS_DISTINCT_FROM: {
                return equals -> !equals;
            }
        }
        throw new KsqlException(String.format("Unsupported comparison between %s and %s: %s", new Object[]{left.getSqlType(), right.getSqlType(), type}));
    }
}

