/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;

public class ArithmeticBinaryTerm
implements Term {
    private final Term left;
    private final Term right;
    private final ArithmeticBinaryFunction arithmeticBinaryFunction;
    private final SqlType resultType;

    public ArithmeticBinaryTerm(Term left, Term right, ArithmeticBinaryFunction arithmeticBinaryFunction, SqlType resultType) {
        this.left = left;
        this.right = right;
        this.arithmeticBinaryFunction = arithmeticBinaryFunction;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        Object leftObject = this.left.getValue(context);
        Object rightObject = this.right.getValue(context);
        if (leftObject == null || rightObject == null) {
            return null;
        }
        return this.arithmeticBinaryFunction.doFunction(this.left.getValue(context), this.right.getValue(context));
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }

    public static interface ArithmeticBinaryFunction {
        public Object doFunction(Object var1, Object var2);
    }
}

