/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.codegen.helpers.ArrayBuilder;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;

public class CreateArrayTerm
implements Term {
    private final List<Term> arrayTerms;
    private final SqlType resultType;

    public CreateArrayTerm(List<Term> arrayTerms, SqlType resultType) {
        this.arrayTerms = arrayTerms;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        ArrayBuilder build = new ArrayBuilder(this.arrayTerms.size());
        for (Term term : this.arrayTerms) {
            build.add(term.getValue(context));
        }
        return build.build();
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }
}

