/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import org.apache.kafka.connect.data.Struct;

public class DereferenceTerm
implements Term {
    private final Term struct;
    private final String fieldName;
    private final SqlType resultType;

    public DereferenceTerm(Term struct, String fieldName, SqlType resultType) {
        this.struct = struct;
        this.fieldName = fieldName;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        Struct structObject = (Struct)this.struct.getValue(context);
        if (structObject == null) {
            return null;
        }
        return structObject.get(this.fieldName);
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }
}

