/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionCallTerm
implements Term {
    private final Kudf kudf;
    private final List<Term> arguments;
    private final Class<?> resultJavaClass;
    private final SqlType resultType;

    public FunctionCallTerm(Kudf kudf, List<Term> arguments, Class<?> resultJavaClass, SqlType resultType) {
        this.kudf = kudf;
        this.arguments = arguments;
        this.resultJavaClass = resultJavaClass;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        List argObjects = this.arguments.stream().map(term -> term.getValue(context)).collect(Collectors.toList());
        Object result = this.kudf.evaluate(argObjects.toArray());
        return this.resultJavaClass.cast(result);
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }
}

