/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.math.BigDecimal;
import java.sql.Timestamp;

public final class LiteralTerms {
    private LiteralTerms() {
    }

    public static Term of(Boolean value) {
        return new BooleanTermImpl(value);
    }

    public static Term of(BigDecimal value, SqlType sqlType) {
        return new DecimalTermImpl(value, sqlType);
    }

    public static Term of(Double value) {
        return new DoubleTermImpl(value);
    }

    public static Term of(Integer value) {
        return new IntegerTermImpl(value);
    }

    public static Term of(Long value) {
        return new LongTermImpl(value);
    }

    public static Term of(String value) {
        return new StringTermImpl(value);
    }

    public static Term of(Timestamp value) {
        return new TimestampTermImpl(value);
    }

    public static NullTerm ofNull() {
        return new NullTerm();
    }

    public static class TimestampTermImpl
    implements Term {
        private final long timeMs;

        public TimestampTermImpl(Timestamp timestamp) {
            this.timeMs = timestamp.getTime();
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return new Timestamp(this.timeMs);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.TIMESTAMP;
        }
    }

    public static class DecimalTermImpl
    implements Term {
        private final BigDecimal value;
        private final SqlType sqlType;

        public DecimalTermImpl(BigDecimal value, SqlType sqlType) {
            this.value = value;
            this.sqlType = sqlType;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return this.sqlType;
        }
    }

    public static class StringTermImpl
    implements Term {
        private final String value;

        public StringTermImpl(String value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.STRING;
        }
    }

    public static class LongTermImpl
    implements Term {
        private final Long value;

        public LongTermImpl(Long value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BIGINT;
        }
    }

    public static class IntegerTermImpl
    implements Term {
        private final Integer value;

        public IntegerTermImpl(Integer value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.INTEGER;
        }
    }

    public static class DoubleTermImpl
    implements Term {
        private final Double value;

        public DoubleTermImpl(Double value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.DOUBLE;
        }
    }

    public static class BooleanTermImpl
    implements Term {
        private final Boolean value;

        public BooleanTermImpl(Boolean value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }

    public static class NullTerm
    implements Term {
        @Override
        public Object getValue(TermEvaluationContext context) {
            return null;
        }

        @Override
        public SqlType getSqlType() {
            return null;
        }
    }
}

