/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class StructTerm
implements Term {
    private final Map<String, Term> nameToTermMap;
    private final SqlType resultType;

    public StructTerm(Map<String, Term> nameToTermMap, SqlType resultType) {
        this.nameToTermMap = nameToTermMap;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        Schema schema = SchemaConverters.sqlToConnectConverter().toConnectSchema(this.resultType);
        Struct struct = new Struct(schema);
        for (Map.Entry<String, Term> entry : this.nameToTermMap.entrySet()) {
            struct.put(entry.getKey(), entry.getValue().getValue(context));
        }
        return struct;
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }
}

