/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.kstream.KTable;

@Immutable
public final class KTableHolder<K> {
    private final KTable<K, GenericRow> stream;
    private final ExecutionKeyFactory<K> executionKeyFactory;
    private final LogicalSchema schema;
    @EffectivelyImmutable
    private final Optional<MaterializationInfo.Builder> materializationBuilder;

    private KTableHolder(KTable<K, GenericRow> stream, LogicalSchema schema, ExecutionKeyFactory<K> executionKeyFactory, Optional<MaterializationInfo.Builder> materializationBuilder) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.executionKeyFactory = Objects.requireNonNull(executionKeyFactory, "keySerdeFactory");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.materializationBuilder = Objects.requireNonNull(materializationBuilder, "materializationProvider");
    }

    public static <K> KTableHolder<K> unmaterialized(KTable<K, GenericRow> stream, LogicalSchema schema, ExecutionKeyFactory<K> executionKeyFactory) {
        return new KTableHolder<K>(stream, schema, executionKeyFactory, Optional.empty());
    }

    public static <K> KTableHolder<K> materialized(KTable<K, GenericRow> stream, LogicalSchema schema, ExecutionKeyFactory<K> executionKeyFactory, MaterializationInfo.Builder materializationBuilder) {
        return new KTableHolder<K>(stream, schema, executionKeyFactory, Optional.of(materializationBuilder));
    }

    public ExecutionKeyFactory<K> getExecutionKeyFactory() {
        return this.executionKeyFactory;
    }

    public KTable<K, GenericRow> getTable() {
        return this.stream;
    }

    public Optional<MaterializationInfo.Builder> getMaterializationBuilder() {
        return this.materializationBuilder;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public KTableHolder<K> withTable(KTable<K, GenericRow> table, LogicalSchema schema) {
        return new KTableHolder<K>(table, schema, this.executionKeyFactory, this.materializationBuilder);
    }

    public KTableHolder<K> withMaterialization(Optional<MaterializationInfo.Builder> builder) {
        return new KTableHolder<K>(this.stream, this.schema, this.executionKeyFactory, builder);
    }
}

