/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamGroupByV1;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableGroupByV1;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;

public class PlanInfoExtractor {
    public <K> PlanInfo visitStreamFilter(StreamFilter<K> streamFilter) {
        return this.visitSingleSourceStep(streamFilter);
    }

    public <K> PlanInfo visitStreamGroupBy(StreamGroupByV1<K> streamGroupBy) {
        return this.visitSingleSourceStep(streamGroupBy);
    }

    public <K> PlanInfo visitStreamGroupBy(StreamGroupBy<K> streamGroupBy) {
        return this.visitSingleSourceStep(streamGroupBy);
    }

    public PlanInfo visitStreamGroupByKey(StreamGroupByKey streamGroupByKey) {
        return this.visitSingleSourceStep(streamGroupByKey);
    }

    public PlanInfo visitStreamAggregate(StreamAggregate streamAggregate) {
        return this.visitSingleSourceStep(streamAggregate);
    }

    public <K> PlanInfo visitStreamSelect(StreamSelect<K> streamSelect) {
        return this.visitSingleSourceStep(streamSelect);
    }

    public <K> PlanInfo visitFlatMap(StreamFlatMap<K> streamFlatMap) {
        return this.visitSingleSourceStep(streamFlatMap);
    }

    public PlanInfo visitStreamSelectKey(StreamSelectKeyV1 streamSelectKey) {
        return this.visitRepartitionStep(streamSelectKey);
    }

    public <K> PlanInfo visitStreamSelectKey(StreamSelectKey<K> streamSelectKey) {
        return this.visitRepartitionStep(streamSelectKey);
    }

    public <K> PlanInfo visitStreamSink(StreamSink<K> streamSink) {
        return this.visitSingleSourceStep(streamSink);
    }

    public PlanInfo visitStreamSource(StreamSource streamSource) {
        return this.visitSourceStep(streamSource);
    }

    public PlanInfo visitWindowedStreamSource(WindowedStreamSource windowedStreamSource) {
        return this.visitSourceStep(windowedStreamSource);
    }

    public <K> PlanInfo visitStreamStreamJoin(StreamStreamJoin<K> streamStreamJoin) {
        return this.visitJoinStep(streamStreamJoin);
    }

    public <K> PlanInfo visitStreamTableJoin(StreamTableJoin<K> streamTableJoin) {
        return this.visitJoinStep(streamTableJoin);
    }

    public PlanInfo visitTableSource(TableSource tableSource) {
        return this.visitSourceStep(tableSource);
    }

    public PlanInfo visitWindowedTableSource(WindowedTableSource windowedTableSource) {
        return this.visitSourceStep(windowedTableSource);
    }

    public PlanInfo visitStreamWindowedAggregate(StreamWindowedAggregate streamWindowedAggregate) {
        return this.visitSingleSourceStep(streamWindowedAggregate);
    }

    public PlanInfo visitTableAggregate(TableAggregate tableAggregate) {
        return this.visitSingleSourceStep(tableAggregate);
    }

    public <K> PlanInfo visitTableFilter(TableFilter<K> tableFilter) {
        return this.visitSingleSourceStep(tableFilter);
    }

    public <K> PlanInfo visitTableGroupBy(TableGroupByV1<K> tableGroupBy) {
        return this.visitSingleSourceStep(tableGroupBy);
    }

    public <K> PlanInfo visitTableGroupBy(TableGroupBy<K> tableGroupBy) {
        return this.visitSingleSourceStep(tableGroupBy);
    }

    public <K> PlanInfo visitTableSelect(TableSelect<K> tableSelect) {
        return this.visitSingleSourceStep(tableSelect);
    }

    public <K> PlanInfo visitTableSelectKey(TableSelectKey<K> tableSelectKey) {
        return this.visitRepartitionStep(tableSelectKey);
    }

    public <K> PlanInfo visitTableSink(TableSink<K> tableSink) {
        return this.visitSingleSourceStep(tableSink);
    }

    public <K> PlanInfo visitTableSuppress(TableSuppress<K> tableSuppress) {
        return this.visitSingleSourceStep(tableSuppress);
    }

    public <K> PlanInfo visitTableTableJoin(TableTableJoin<K> tableTableJoin) {
        return this.visitJoinStep(tableTableJoin);
    }

    private PlanInfo visitSourceStep(ExecutionStep<?> step) {
        return new PlanInfo(step);
    }

    private PlanInfo visitRepartitionStep(ExecutionStep<?> step) {
        PlanInfo sourceInfo = step.getSources().get(0).extractPlanInfo(this);
        return sourceInfo.setIsRepartitionedInPlan();
    }

    private PlanInfo visitJoinStep(ExecutionStep<?> step) {
        PlanInfo leftInfo = step.getSources().get(0).extractPlanInfo(this);
        PlanInfo rightInfo = step.getSources().get(1).extractPlanInfo(this);
        return leftInfo.merge(rightInfo);
    }

    private PlanInfo visitSingleSourceStep(ExecutionStep<?> step) {
        return step.getSources().get(0).extractPlanInfo(this);
    }
}

