/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KGroupedStreamHolder;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@Immutable
public class StreamGroupBy<K>
implements ExecutionStep<KGroupedStreamHolder> {
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("group by clause", s -> ((StreamGroupBy)s).groupByExpressions), (Object)new ExecutionStep.Property("internal formats", s -> ((StreamGroupBy)s).internalFormats));
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final Formats internalFormats;
    private final ImmutableList<Expression> groupByExpressions;

    public StreamGroupBy(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="internalFormats", required=true) Formats internalFormats, @JsonProperty(value="groupByExpressions", required=true) List<Expression> groupBys) {
        this.properties = Objects.requireNonNull(props, "props");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.source = Objects.requireNonNull(source, "source");
        this.groupByExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupBys, "groupBys"));
        if (this.groupByExpressions.isEmpty()) {
            throw new IllegalArgumentException("Need at least one grouping expression");
        }
    }

    public List<Expression> getGroupByExpressions() {
        return this.groupByExpressions;
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KGroupedStreamHolder build(PlanBuilder builder, PlanInfo info) {
        return builder.visitStreamGroupBy(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitStreamGroupBy(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((StreamGroupBy)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamGroupBy that = (StreamGroupBy)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.internalFormats, that.internalFormats) && Objects.equals(this.groupByExpressions, that.groupByExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.internalFormats, this.groupByExpressions);
    }
}

