/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@Immutable
public class StreamSelectKey<K>
implements ExecutionStep<KStreamHolder<K>> {
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("keyExpressions", s -> ((StreamSelectKey)s).keyExpressions));
    private final ExecutionStepPropertiesV1 properties;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private final ImmutableList<Expression> keyExpressions;
    @EffectivelyImmutable
    private final ExecutionStep<? extends KStreamHolder<K>> source;

    public StreamSelectKey(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<? extends KStreamHolder<K>> source, @JsonProperty(value="keyExpression", required=true) List<Expression> keyExpressions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.keyExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(keyExpressions, "keyExpressions"));
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty(value="keyExpression", required=true)
    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public ExecutionStep<? extends KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitStreamSelectKey(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitStreamSelectKey(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((StreamSelectKey)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSelectKey that = (StreamSelectKey)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.keyExpressions, that.keyExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.keyExpressions);
    }
}

