/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.JoinType;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.name.ColumnName;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StreamStreamJoin<K>
implements ExecutionStep<KStreamHolder<K>> {
    public static final String LEGACY_KEY_COL = "ROWKEY";
    private final ExecutionStepPropertiesV1 properties;
    private final JoinType joinType;
    private final ColumnName keyColName;
    private final Formats leftInternalFormats;
    private final Formats rightInternalFormats;
    private final ExecutionStep<KStreamHolder<K>> leftSource;
    private final ExecutionStep<KStreamHolder<K>> rightSource;
    private final Duration beforeMillis;
    private final Duration afterMillis;

    @JsonCreator
    @Deprecated
    private StreamStreamJoin(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="joinType", required=true) JoinType joinType, @JsonProperty(value="keyName", defaultValue="ROWKEY") Optional<ColumnName> keyColName, @JsonProperty(value="leftInternalFormats", required=true) Formats leftIntFormats, @JsonProperty(value="rightInternalFormats", required=true) Formats rightIntFormats, @JsonProperty(value="leftSource", required=true) ExecutionStep<KStreamHolder<K>> leftSource, @JsonProperty(value="rightSource", required=true) ExecutionStep<KStreamHolder<K>> rightSource, @JsonProperty(value="beforeMillis", required=true) Duration beforeMillis, @JsonProperty(value="afterMillis", required=true) Duration afterMillis) {
        this(props, joinType, keyColName.orElse(ColumnName.of((String)LEGACY_KEY_COL)), leftIntFormats, rightIntFormats, leftSource, rightSource, beforeMillis, afterMillis);
    }

    public StreamStreamJoin(ExecutionStepPropertiesV1 props, JoinType joinType, ColumnName keyColName, Formats leftIntFormats, Formats rightIntFormats, ExecutionStep<KStreamHolder<K>> leftSource, ExecutionStep<KStreamHolder<K>> rightSource, Duration beforeMillis, Duration afterMillis) {
        this.properties = Objects.requireNonNull(props, "props");
        this.leftInternalFormats = Objects.requireNonNull(leftIntFormats, "leftIntFormats");
        this.rightInternalFormats = Objects.requireNonNull(rightIntFormats, "rightIntFormats");
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.keyColName = Objects.requireNonNull(keyColName, "keyColName");
        this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
        this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
        this.beforeMillis = Objects.requireNonNull(beforeMillis, "beforeMillis");
        this.afterMillis = Objects.requireNonNull(afterMillis, "afterMillis");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return ImmutableList.of(this.leftSource, this.rightSource);
    }

    public Formats getLeftInternalFormats() {
        return this.leftInternalFormats;
    }

    public Formats getRightInternalFormats() {
        return this.rightInternalFormats;
    }

    public ExecutionStep<KStreamHolder<K>> getLeftSource() {
        return this.leftSource;
    }

    public ExecutionStep<KStreamHolder<K>> getRightSource() {
        return this.rightSource;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ColumnName getKeyColName() {
        return this.keyColName;
    }

    public Duration getAfterMillis() {
        return this.afterMillis;
    }

    public Duration getBeforeMillis() {
        return this.beforeMillis;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitStreamStreamJoin(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitStreamStreamJoin(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamStreamJoin that = (StreamStreamJoin)o;
        return Objects.equals(this.properties, that.properties) && this.joinType == that.joinType && Objects.equals(this.keyColName, that.keyColName) && Objects.equals(this.leftInternalFormats, that.leftInternalFormats) && Objects.equals(this.rightInternalFormats, that.rightInternalFormats) && Objects.equals(this.leftSource, that.leftSource) && Objects.equals(this.rightSource, that.rightSource) && Objects.equals(this.beforeMillis, that.beforeMillis) && Objects.equals(this.afterMillis, that.afterMillis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.joinType, this.keyColName, this.leftInternalFormats, this.rightInternalFormats, this.leftSource, this.rightSource, this.beforeMillis, this.afterMillis});
    }
}

