/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.WindowInfo;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Windowed;

@Immutable
public final class WindowedStreamSource
extends SourceStep<KStreamHolder<Windowed<GenericKey>>> {
    private final WindowInfo windowInfo;

    public WindowedStreamSource(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="topicName", required=true) String topicName, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="windowInfo", required=true) WindowInfo windowInfo, @JsonProperty(value="timestampColumn") Optional<TimestampColumn> timestampColumn, @JsonProperty(value="sourceSchema", required=true) LogicalSchema sourceSchema) {
        super(props, topicName, formats, timestampColumn, sourceSchema);
        this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
    }

    public WindowInfo getWindowInfo() {
        return this.windowInfo;
    }

    @Override
    public KStreamHolder<Windowed<GenericKey>> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitWindowedStreamSource(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitWindowedStreamSource(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedStreamSource that = (WindowedStreamSource)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.formats, that.formats) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.sourceSchema, that.sourceSchema);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.topicName, this.formats, this.timestampColumn, this.sourceSchema);
    }
}

