/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.select;

import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.execution.transform.select.SelectValueMapperFactory;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Selection<K> {
    private final SelectValueMapper<K> mapper;
    private final LogicalSchema schema;

    public static <K> Selection<K> of(LogicalSchema sourceSchema, List<ColumnName> keyColumnNames, List<SelectExpression> selectExpressions, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        SelectValueMapper mapper = SelectValueMapperFactory.create(selectExpressions, sourceSchema, ksqlConfig, functionRegistry);
        LogicalSchema schema = Selection.buildSchema(sourceSchema, mapper, keyColumnNames);
        return new Selection(mapper, schema);
    }

    private static LogicalSchema buildSchema(LogicalSchema sourceSchema, SelectValueMapper<?> mapper, List<ColumnName> keyColumnNames) {
        List<ColumnName> keyNames = keyColumnNames.isEmpty() ? Selection.getKeyColumnNames(sourceSchema) : keyColumnNames;
        List keyCols = sourceSchema.key();
        if (keyNames.size() != keyCols.size()) {
            throw new IllegalArgumentException("key name count mismatch. names: " + keyNames + ", keys: " + keyCols);
        }
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        for (int i = 0; i != keyCols.size(); ++i) {
            schemaBuilder.keyColumn(keyNames.get(i), ((Column)keyCols.get(i)).type());
        }
        for (SelectValueMapper.SelectInfo select : mapper.getSelects()) {
            schemaBuilder.valueColumn(select.getFieldName(), select.getEvaluator().getExpressionType());
        }
        return schemaBuilder.build();
    }

    private static List<ColumnName> getKeyColumnNames(LogicalSchema sourceSchema) {
        return sourceSchema.key().stream().map(Column::name).collect(Collectors.toList());
    }

    private Selection(SelectValueMapper<K> mapper, LogicalSchema schema) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public SelectValueMapper<K> getMapper() {
        return this.mapper;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }
}

