/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

final class ComparisonUtil {
    private static final List<Handler> HANDLERS = ImmutableList.builder().add((Object)ComparisonUtil.handler(SqlBaseType::isNumber, ComparisonUtil::handleNumber)).add((Object)ComparisonUtil.handler(SqlBaseType.STRING, ComparisonUtil::handleString)).add((Object)ComparisonUtil.handler(SqlBaseType.BOOLEAN, ComparisonUtil::handleBoolean)).add((Object)ComparisonUtil.handler(SqlBaseType.ARRAY, ComparisonUtil::handleArray)).add((Object)ComparisonUtil.handler(SqlBaseType.MAP, ComparisonUtil::handleMap)).add((Object)ComparisonUtil.handler(SqlBaseType.STRUCT, ComparisonUtil::handleStruct)).add((Object)ComparisonUtil.handler(SqlBaseType.TIMESTAMP, ComparisonUtil::handleTimestamp)).build();

    private ComparisonUtil() {
    }

    static boolean isValidComparison(SqlType left, ComparisonExpression.Type operator, SqlType right) {
        if (left == null || right == null) {
            throw ComparisonUtil.nullSchemaException(left, operator, right);
        }
        return HANDLERS.stream().filter(h -> h.handles.test(left.baseType())).findFirst().map(h -> h.validator.test(operator, right)).orElse(false);
    }

    private static KsqlException nullSchemaException(SqlType left, ComparisonExpression.Type operator, SqlType right) {
        String leftType = left == null ? "NULL" : left.baseType().name();
        String rightType = right == null ? "NULL" : right.baseType().name();
        return new KsqlException("Comparison with NULL not supported: " + leftType + " " + operator.getValue() + " " + rightType + System.lineSeparator() + "Use 'IS NULL' or 'IS NOT NULL' instead.");
    }

    private static boolean handleNumber(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType().isNumber();
    }

    private static boolean handleString(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.STRING || right.baseType() == SqlBaseType.TIMESTAMP;
    }

    private static boolean handleBoolean(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.BOOLEAN && ComparisonUtil.isEqualityOperator(operator);
    }

    private static boolean handleArray(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.ARRAY && ComparisonUtil.isEqualityOperator(operator);
    }

    private static boolean handleMap(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.MAP && ComparisonUtil.isEqualityOperator(operator);
    }

    private static boolean handleStruct(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.STRUCT && ComparisonUtil.isEqualityOperator(operator);
    }

    private static boolean handleTimestamp(ComparisonExpression.Type operator, SqlType right) {
        return right.baseType() == SqlBaseType.TIMESTAMP || right.baseType() == SqlBaseType.STRING;
    }

    private static boolean isEqualityOperator(ComparisonExpression.Type operator) {
        return operator == ComparisonExpression.Type.EQUAL || operator == ComparisonExpression.Type.NOT_EQUAL || operator == ComparisonExpression.Type.IS_DISTINCT_FROM || operator == ComparisonExpression.Type.IS_NOT_DISTINCT_FROM;
    }

    private static Handler handler(SqlBaseType baseType, BiPredicate<ComparisonExpression.Type, SqlType> validator) {
        return ComparisonUtil.handler((SqlBaseType t) -> t == baseType, validator);
    }

    private static Handler handler(Predicate<SqlBaseType> handles, BiPredicate<ComparisonExpression.Type, SqlType> validator) {
        return new Handler(handles, validator);
    }

    private static final class Handler {
        final Predicate<SqlBaseType> handles;
        final BiPredicate<ComparisonExpression.Type, SqlType> validator;

        private Handler(Predicate<SqlBaseType> handles, BiPredicate<ComparisonExpression.Type, SqlType> validator) {
            this.handles = Objects.requireNonNull(handles, "handles");
            this.validator = Objects.requireNonNull(validator, "validator");
        }
    }
}

