/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.codegen.LambdaMappingUtil;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.LambdaType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlLambda;
import io.confluent.ksql.schema.ksql.types.SqlLambdaResolved;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class FunctionArgumentsUtil {
    private FunctionArgumentsUtil() {
    }

    public static FunctionTypeInfo getFunctionTypeInfo(ExpressionTypeManager expressionTypeManager, FunctionCall functionCall, UdfFactory udfFactory, Map<String, SqlType> lambdaMapping) {
        List<Expression> arguments = functionCall.getArguments();
        List<SqlArgument> functionArgumentTypes = FunctionArgumentsUtil.firstPassOverFunctionArguments(arguments, expressionTypeManager, lambdaMapping);
        KsqlScalarFunction function = udfFactory.getFunction(functionArgumentTypes);
        ArrayList<ArgumentInfo> argumentInfoForFunction = new ArrayList<ArgumentInfo>();
        if (!functionCall.hasLambdaFunctionCallArguments()) {
            SqlType returnSchema = function.getReturnType(functionArgumentTypes);
            return FunctionTypeInfo.of(functionArgumentTypes.stream().map(argument -> ArgumentInfo.of(argument, new HashMap(lambdaMapping))).collect(Collectors.toList()), returnSchema, function);
        }
        List paramTypes = function.parameters();
        HashMap<GenericType, SqlType> reservedGenerics = new HashMap<GenericType, SqlType>();
        ArrayList<SqlArgument> functionArgumentTypesWithResolvedLambdaType = new ArrayList<SqlArgument>();
        for (int i = 0; i < arguments.size(); ++i) {
            Pair success;
            Expression expression = arguments.get(i);
            ParamType parameter = (ParamType)paramTypes.get(i);
            if (expression instanceof LambdaFunctionCall) {
                if (!(parameter instanceof LambdaType)) {
                    throw new RuntimeException(String.format("Error while processing lambda function.Expected lambda parameter but was %sThis is most likely an internal error and a Github issue should be filed for debugging. Include the function name, the parameters passed in, the expected signature, and any other relevant information.", parameter.toString()));
                }
                ArrayList<SqlType> lambdaSqlTypes = new ArrayList<SqlType>();
                Map<String, SqlType> variableTypeMapping = FunctionArgumentsUtil.mapLambdaParametersToTypes((LambdaFunctionCall)expression, (LambdaType)parameter, reservedGenerics, lambdaSqlTypes);
                Map<String, SqlType> updateLambdaMapping = LambdaMappingUtil.resolveOldAndNewLambdaMapping(variableTypeMapping, lambdaMapping);
                SqlType resolvedLambdaReturnType = expressionTypeManager.getExpressionSqlType(expression, updateLambdaMapping);
                SqlArgument lambdaArgument = SqlArgument.of((SqlLambda)SqlLambdaResolved.of(lambdaSqlTypes, (SqlType)resolvedLambdaReturnType));
                functionArgumentTypesWithResolvedLambdaType.add(lambdaArgument);
                argumentInfoForFunction.add(ArgumentInfo.of(lambdaArgument, new HashMap<String, SqlType>(updateLambdaMapping)));
            } else {
                functionArgumentTypesWithResolvedLambdaType.add(functionArgumentTypes.get(i));
                argumentInfoForFunction.add(ArgumentInfo.of(functionArgumentTypes.get(i), new HashMap<String, SqlType>(lambdaMapping)));
            }
            if (!GenericsUtil.hasGenerics((ParamType)parameter) || ((Boolean)(success = GenericsUtil.reserveGenerics((ParamType)parameter, (SqlArgument)((SqlArgument)functionArgumentTypesWithResolvedLambdaType.get(i)), reservedGenerics)).getLeft()).booleanValue() || !((Optional)success.getRight()).isPresent()) continue;
            throw (KsqlException)((Optional)success.getRight()).get();
        }
        SqlType returnSchema = function.getReturnType(functionArgumentTypesWithResolvedLambdaType);
        return new FunctionTypeInfo(argumentInfoForFunction, returnSchema, function);
    }

    private static List<SqlArgument> firstPassOverFunctionArguments(List<Expression> arguments, ExpressionTypeManager expressionTypeManager, Map<String, SqlType> lambdaMapping) {
        ArrayList<SqlArgument> functionArgumentTypes = new ArrayList<SqlArgument>();
        for (Expression expression : arguments) {
            if (expression instanceof LambdaFunctionCall) {
                functionArgumentTypes.add(SqlArgument.of((SqlLambda)SqlLambda.of((Integer)((LambdaFunctionCall)expression).getArguments().size())));
                continue;
            }
            SqlType resolvedArgType = expressionTypeManager.getExpressionSqlType(expression, new HashMap<String, SqlType>(lambdaMapping));
            functionArgumentTypes.add(SqlArgument.of((SqlType)resolvedArgType));
        }
        return functionArgumentTypes;
    }

    private static Map<String, SqlType> mapLambdaParametersToTypes(LambdaFunctionCall lambdaFunctionCall, LambdaType lambdaParameter, Map<GenericType, SqlType> reservedGenerics, ArrayList<SqlType> lambdaSqlTypes) {
        if (lambdaFunctionCall.getArguments().size() != lambdaParameter.inputTypes().size()) {
            throw new IllegalArgumentException("Was expecting " + lambdaParameter.inputTypes().size() + " arguments but found " + lambdaFunctionCall.getArguments().size() + ", " + lambdaFunctionCall.getArguments() + ". Check your lambda statement.");
        }
        ListIterator<String> lambdaArgs = lambdaFunctionCall.getArguments().listIterator();
        HashMap variableTypeMapping = new HashMap();
        for (ParamType inputParam : lambdaParameter.inputTypes()) {
            if (inputParam instanceof GenericType) {
                GenericType genericParam = (GenericType)inputParam;
                if (!reservedGenerics.containsKey(genericParam)) {
                    throw new RuntimeException(String.format("Could not resolve type for generic %s. The generic mapping so far: %s", genericParam.toString(), reservedGenerics.toString()));
                }
                variableTypeMapping.put(lambdaArgs.next(), reservedGenerics.get(genericParam));
                lambdaSqlTypes.add(reservedGenerics.get(genericParam));
                continue;
            }
            variableTypeMapping.put(lambdaArgs.next(), SchemaConverters.functionToSqlConverter().toSqlType(inputParam));
            lambdaSqlTypes.add(SchemaConverters.functionToSqlConverter().toSqlType(inputParam));
        }
        return ImmutableMap.copyOf(variableTypeMapping);
    }

    public static final class ArgumentInfo {
        final SqlArgument sqlArgument;
        final Map<String, SqlType> lambdaSqlTypeMapping;

        private static ArgumentInfo of(SqlArgument sqlArgument, Map<String, SqlType> lambdaSqlTypeMapping) {
            return new ArgumentInfo(sqlArgument, lambdaSqlTypeMapping);
        }

        private ArgumentInfo(SqlArgument sqlArgument, Map<String, SqlType> lambdaSqlTypeMapping) {
            this.sqlArgument = sqlArgument;
            this.lambdaSqlTypeMapping = lambdaSqlTypeMapping;
        }

        public SqlArgument getSqlArgument() {
            return this.sqlArgument;
        }

        public Map<String, SqlType> getLambdaSqlTypeMapping() {
            return this.lambdaSqlTypeMapping;
        }
    }

    public static final class FunctionTypeInfo {
        private final List<ArgumentInfo> argumentInfos;
        private final SqlType returnType;
        private final KsqlScalarFunction function;

        private static FunctionTypeInfo of(List<ArgumentInfo> argumentInfos, SqlType returnType, KsqlScalarFunction function) {
            return new FunctionTypeInfo(argumentInfos, returnType, function);
        }

        private FunctionTypeInfo(List<ArgumentInfo> argumentInfos, SqlType returnType, KsqlScalarFunction function) {
            this.argumentInfos = argumentInfos;
            this.returnType = returnType;
            this.function = function;
        }

        public List<ArgumentInfo> getArgumentInfos() {
            return this.argumentInfos;
        }

        public SqlType getReturnType() {
            return this.returnType;
        }

        public KsqlScalarFunction getFunction() {
            return this.function;
        }
    }
}

