/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.execution.expression.tree.TimestampLiteral;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.function.Function;

public final class Literals {
    private static final ImmutableMap<SqlBaseType, Function<Object, ? extends Literal>> FACTORIES = ImmutableMap.builder().put((Object)SqlBaseType.BOOLEAN, v -> new BooleanLiteral((Boolean)v)).put((Object)SqlBaseType.INTEGER, v -> new IntegerLiteral((Integer)v)).put((Object)SqlBaseType.BIGINT, v -> new LongLiteral((Long)v)).put((Object)SqlBaseType.DECIMAL, v -> new DecimalLiteral((BigDecimal)v)).put((Object)SqlBaseType.DOUBLE, v -> new DoubleLiteral((Double)v)).put((Object)SqlBaseType.STRING, v -> new StringLiteral((String)v)).put((Object)SqlBaseType.TIMESTAMP, v -> new TimestampLiteral((Timestamp)v)).build();

    private Literals() {
    }

    public static Function<Object, ? extends Literal> getFactory(SqlBaseType sqlType) {
        Function factory = (Function)FACTORIES.get((Object)sqlType);
        if (factory == null) {
            throw new IllegalArgumentException("No literal type registered for " + sqlType);
        }
        return factory;
    }
}

