/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggingJsonMapper;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordProcessingError
implements ProcessingLogger.ErrorMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordProcessingError.class);
    private final String errorMsg;
    private final Optional<Throwable> exception;
    private final Optional<Supplier<String>> record;

    public static ProcessingLogger.ErrorMessage recordProcessingError(String errorMsg, Throwable exception, GenericRow record) {
        return new RecordProcessingError(errorMsg, Optional.of(exception), Optional.ofNullable(record).map(r -> () -> RecordProcessingError.serializeRow(r)));
    }

    public static ProcessingLogger.ErrorMessage recordProcessingError(String errorMsg, GenericRow record) {
        return new RecordProcessingError(errorMsg, Optional.empty(), Optional.ofNullable(record).map(r -> () -> RecordProcessingError.serializeRow(r)));
    }

    public static ProcessingLogger.ErrorMessage recordProcessingError(String errorMsg, Throwable exception, Supplier<String> record) {
        return new RecordProcessingError(errorMsg, Optional.of(exception), Optional.ofNullable(record));
    }

    private RecordProcessingError(String errorMsg, Optional<Throwable> exception, Optional<Supplier<String>> record) {
        this.errorMsg = Objects.requireNonNull(errorMsg, "errorMsg");
        this.exception = Objects.requireNonNull(exception, "exception");
        this.record = Objects.requireNonNull(record, "record");
    }

    public String getMessage() {
        return this.errorMsg;
    }

    public Optional<Throwable> getException() {
        return this.exception;
    }

    public SchemaAndValue get(ProcessingLogConfig config) {
        Struct struct = new Struct(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA).put("type", (Object)ProcessingLogMessageSchema.MessageType.RECORD_PROCESSING_ERROR.getTypeId()).put("recordProcessingError", (Object)this.processingError(config));
        return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordProcessingError that = (RecordProcessingError)o;
        return Objects.equals(this.errorMsg, that.errorMsg) && Objects.equals(this.exception.map(Object::getClass), that.exception.map(Object::getClass)) && Objects.equals(this.exception.map(Object::toString), that.exception.map(Object::toString)) && Objects.equals(this.record.map(Supplier::get), that.record.map(Supplier::get));
    }

    public int hashCode() {
        return Objects.hash(this.errorMsg, this.exception, this.record);
    }

    private Struct processingError(ProcessingLogConfig config) {
        Struct recordProcessingError = new Struct(ProcessingLogMessageSchema.MessageType.RECORD_PROCESSING_ERROR.getSchema()).put("errorMessage", (Object)this.errorMsg).put("cause", this.exception.map(ErrorMessageUtil::getErrorMessages).orElse(Collections.emptyList()));
        if (config.getBoolean(ProcessingLogConfig.INCLUDE_ROWS).booleanValue()) {
            this.record.ifPresent(r -> recordProcessingError.put("record", r.get()));
        }
        return recordProcessingError;
    }

    private static String serializeRow(GenericRow record) {
        try {
            return ProcessingLoggingJsonMapper.INSTANCE.get().writeValueAsString((Object)record.values());
        }
        catch (Throwable t) {
            LOGGER.error("error serializing record for processing log", t);
            return null;
        }
    }
}

