/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.ValueFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class QuerySchemas {
    private final LinkedHashMap<String, SchemaInfo> loggerToSchemas = new LinkedHashMap();
    private final Map<String, Map<Boolean, Set<String>>> topicsToLoggers = new HashMap<String, Map<Boolean, Set<String>>>();

    public void trackKeySerdeCreation(String loggerNamePrefix, LogicalSchema schema, KeyFormat keyFormat) {
        this.trackSerde(loggerNamePrefix, schema, Optional.of(keyFormat), Optional.empty());
    }

    public void trackValueSerdeCreation(String loggerNamePrefix, LogicalSchema schema, ValueFormat valueFormat) {
        this.trackSerde(loggerNamePrefix, schema, Optional.empty(), Optional.of(valueFormat));
    }

    public synchronized void trackSerdeOp(String topicName, boolean key, String loggerNamePrefix) {
        this.topicsToLoggers.computeIfAbsent(topicName, k1 -> new HashMap()).computeIfAbsent(key, k -> new HashSet()).add(loggerNamePrefix);
    }

    public Map<String, SchemaInfo> getLoggerSchemaInfo() {
        return Collections.unmodifiableMap(this.loggerToSchemas);
    }

    public SchemaInfo getTopicInfo(String topicName) {
        Map<Boolean, Set<String>> kvLoggerNames = this.topicsToLoggers.get(topicName);
        if (kvLoggerNames == null) {
            throw new IllegalArgumentException("Unknown topic: " + topicName);
        }
        Set<String> keyLoggerNames = kvLoggerNames.getOrDefault(true, (Set<String>)ImmutableSet.of());
        if (keyLoggerNames.size() != 1) {
            throw new IllegalStateException("Multiple key logger names registered for topic." + System.lineSeparator() + "topic: " + topicName + "loggers: " + keyLoggerNames);
        }
        Set<String> valueTopicNames = kvLoggerNames.getOrDefault(false, (Set<String>)ImmutableSet.of());
        if (valueTopicNames.size() != 1) {
            throw new IllegalStateException("Multiple value logger names registered for topic." + System.lineSeparator() + "topic: " + topicName + "loggers: " + valueTopicNames);
        }
        SchemaInfo keyInfo = this.loggerToSchemas.get(Iterables.getOnlyElement(keyLoggerNames));
        SchemaInfo valueInfo = this.loggerToSchemas.get(Iterables.getOnlyElement(valueTopicNames));
        if (keyInfo == null || valueInfo == null) {
            throw new IllegalStateException("Incomplete schema info for topic." + System.lineSeparator() + "topic: " + topicName + "keyInfo: " + keyInfo + "valueInfo: " + valueInfo);
        }
        return keyInfo.equals(valueInfo) ? valueInfo : valueInfo.merge(keyInfo.keyFormat, keyInfo.valueFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySchemas that = (QuerySchemas)o;
        return Objects.equals(this.loggerToSchemas, that.loggerToSchemas) && Objects.equals(this.topicsToLoggers, that.topicsToLoggers);
    }

    public int hashCode() {
        return Objects.hash(this.loggerToSchemas, this.topicsToLoggers);
    }

    private void trackSerde(String loggerNamePrefix, LogicalSchema schema, Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
        this.loggerToSchemas.compute(loggerNamePrefix, (k, existing) -> {
            if (existing == null) {
                return new SchemaInfo(schema, keyFormat, valueFormat);
            }
            if (!((SchemaInfo)existing).schema.equals((Object)schema)) {
                throw new IllegalStateException("Inconsistent schema: existing: " + ((SchemaInfo)existing).schema + ", new: " + schema);
            }
            return existing.merge(keyFormat, valueFormat);
        });
    }

    @Immutable
    public static final class SchemaInfo {
        private final LogicalSchema schema;
        private final Optional<KeyFormat> keyFormat;
        private final Optional<ValueFormat> valueFormat;

        public SchemaInfo(LogicalSchema schema, Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
            this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        }

        public String toString() {
            return "schema=" + this.schema + ", keyFormat=" + this.keyFormat.map(Object::toString).orElse("?") + ", valueFormat=" + this.valueFormat.map(Object::toString).orElse("?");
        }

        public LogicalSchema schema() {
            return this.schema;
        }

        public Optional<KeyFormat> keyFormat() {
            return this.keyFormat;
        }

        public Optional<ValueFormat> valueFormat() {
            return this.valueFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaInfo that = (SchemaInfo)o;
            return Objects.equals(this.schema, that.schema) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.valueFormat, that.valueFormat);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.keyFormat, this.valueFormat);
        }

        SchemaInfo merge(Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
            if (this.keyFormat.isPresent() && keyFormat.isPresent()) {
                throw new IllegalStateException("key format already set");
            }
            if (this.valueFormat.isPresent() && valueFormat.isPresent()) {
                throw new IllegalStateException("value format already set");
            }
            return new SchemaInfo(this.schema, keyFormat.isPresent() ? keyFormat : this.keyFormat, valueFormat.isPresent() ? valueFormat : this.valueFormat);
        }
    }
}

