/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenUtil;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;

@Immutable
public final class CodeGenSpec {
    private final ImmutableList<ArgumentSpec> arguments;
    private final ImmutableMap<ColumnName, String> columnToCodeName;
    private final ImmutableListMultimap<FunctionName, String> functionToCodeName;
    private final ImmutableMap<CreateStructExpression, String> structToCodeName;

    private CodeGenSpec(ImmutableList<ArgumentSpec> arguments, ImmutableMap<ColumnName, String> columnToCodeName, ImmutableListMultimap<FunctionName, String> functionToCodeName, ImmutableMap<CreateStructExpression, String> structToCodeName) {
        this.arguments = arguments;
        this.columnToCodeName = columnToCodeName;
        this.functionToCodeName = functionToCodeName;
        this.structToCodeName = structToCodeName;
    }

    public String[] argumentNames() {
        return (String[])this.arguments.stream().map(ArgumentSpec::name).toArray(String[]::new);
    }

    public Class<?>[] argumentTypes() {
        return (Class[])this.arguments.stream().map(ArgumentSpec::type).toArray(Class[]::new);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="arguments is ImmutableList")
    public List<ArgumentSpec> arguments() {
        return this.arguments;
    }

    public String getCodeName(ColumnName columnName) {
        return (String)this.columnToCodeName.get((Object)columnName);
    }

    public String getUniqueNameForFunction(FunctionName functionName, int index) {
        ImmutableList names = this.functionToCodeName.get((Object)functionName);
        if (names.size() <= index) {
            throw new KsqlException("Cannot get name for " + functionName + " " + index + " times");
        }
        return (String)names.get(index);
    }

    public void resolve(GenericRow row, Object[] parameters) {
        for (int paramIdx = 0; paramIdx < this.arguments.size(); ++paramIdx) {
            parameters[paramIdx] = ((ArgumentSpec)this.arguments.get(paramIdx)).resolve(row);
        }
    }

    public String getStructSchemaName(CreateStructExpression createStructExpression) {
        String schemaName = (String)this.structToCodeName.get((Object)createStructExpression);
        if (schemaName == null) {
            throw new KsqlException("Cannot get name for " + ExpressionFormatter.formatExpression(createStructExpression));
        }
        return schemaName;
    }

    @Immutable
    public static final class SchemaArgumentSpec
    extends BaseArgumentSpec {
        private final ConnectSchema schema;

        SchemaArgumentSpec(String name, Schema schema) {
            super(name, Schema.class);
            this.schema = (ConnectSchema)Objects.requireNonNull(schema, "schema").schema();
        }

        @Override
        public Object resolve(GenericRow value) {
            return this.schema;
        }

        public String toString() {
            return "StructSchemaArgumentSpec{name='" + this.name() + '\'' + ", type=" + this.type() + ", schema=" + this.schema + '}';
        }
    }

    @Immutable
    public static final class ValueArgumentSpec
    extends BaseArgumentSpec {
        private final int columnIndex;

        ValueArgumentSpec(String name, Class<?> type, int columnIndex) {
            super(name, type);
            this.columnIndex = columnIndex;
        }

        @Override
        public Object resolve(GenericRow value) {
            return value.get(this.columnIndex);
        }

        public String toString() {
            return "ValueArgumentSpec{name='" + this.name() + '\'' + ", type=" + this.type() + ", columnIndex=" + this.columnIndex + '}';
        }
    }

    @Immutable
    private static final class FunctionArgumentSpec
    extends BaseArgumentSpec {
        @EffectivelyImmutable
        private final Kudf kudf;

        FunctionArgumentSpec(String name, Class<?> type, Kudf kudf) {
            super(name, type);
            this.kudf = Objects.requireNonNull(kudf, "kudf");
        }

        @Override
        public Object resolve(GenericRow value) {
            return this.kudf;
        }

        public String toString() {
            return "FunctionArgumentSpec{name='" + this.name() + '\'' + ", type=" + this.type() + ", kudf=" + this.kudf + '}';
        }
    }

    @Immutable
    private static abstract class BaseArgumentSpec
    implements ArgumentSpec {
        private final String name;
        private final Class<?> type;

        BaseArgumentSpec(String name, Class<?> type) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }
    }

    @Immutable
    public static interface ArgumentSpec {
        public String name();

        public Class<?> type();

        public Object resolve(GenericRow var1);
    }

    static class Builder {
        private final ImmutableList.Builder<ArgumentSpec> argumentBuilder = ImmutableList.builder();
        private final Map<ColumnName, String> columnRefToName = new HashMap<ColumnName, String>();
        private final ImmutableListMultimap.Builder<FunctionName, String> functionNameBuilder = ImmutableListMultimap.builder();
        private final Map<CreateStructExpression, String> structToSchemaName = new HashMap<CreateStructExpression, String>();
        private int argumentCount = 0;
        private int structSchemaCount = 0;

        Builder() {
        }

        void addParameter(ColumnName columnName, Class<?> type, int colIndex) {
            String codeName = CodeGenUtil.paramName(this.argumentCount++);
            this.columnRefToName.put(columnName, codeName);
            this.argumentBuilder.add((Object)new ValueArgumentSpec(codeName, type, colIndex));
        }

        void addFunction(FunctionName functionName, Kudf function) {
            String codeName = CodeGenUtil.functionName(functionName, this.argumentCount++);
            this.functionNameBuilder.put((Object)functionName, (Object)codeName);
            this.argumentBuilder.add((Object)new FunctionArgumentSpec(codeName, function.getClass(), function));
        }

        void addStructSchema(CreateStructExpression struct, Schema schema) {
            if (this.structToSchemaName.containsKey((Object)struct)) {
                return;
            }
            String structSchemaName = CodeGenUtil.schemaName(this.structSchemaCount++);
            this.structToSchemaName.put(struct, structSchemaName);
            this.argumentBuilder.add((Object)new SchemaArgumentSpec(structSchemaName, schema));
        }

        CodeGenSpec build() {
            return new CodeGenSpec(this.argumentBuilder.build(), ImmutableMap.copyOf(this.columnRefToName), this.functionNameBuilder.build(), ImmutableMap.copyOf(this.structToSchemaName));
        }
    }
}

