/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenSpec;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.commons.compiler.IExpressionEvaluator;

@Immutable
public class CompiledExpression
implements ExpressionEvaluator {
    @EffectivelyImmutable
    private final IExpressionEvaluator expressionEvaluator;
    private final SqlType expressionType;
    private final ThreadLocal<Object[]> threadLocalParameters;
    private final Expression expression;
    private final CodeGenSpec spec;

    public CompiledExpression(IExpressionEvaluator expressionEvaluator, CodeGenSpec spec, SqlType expressionType, Expression expression) {
        this.expressionEvaluator = Objects.requireNonNull(expressionEvaluator, "expressionEvaluator");
        this.expressionType = Objects.requireNonNull(expressionType, "expressionType");
        this.expression = Objects.requireNonNull(expression, "expression");
        this.spec = Objects.requireNonNull(spec, "spec");
        this.threadLocalParameters = ThreadLocal.withInitial(() -> new Object[spec.arguments().size()]);
    }

    public List<CodeGenSpec.ArgumentSpec> arguments() {
        return this.spec.arguments();
    }

    @Override
    public SqlType getExpressionType() {
        return this.expressionType;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluate(GenericRow row, Object defaultValue, ProcessingLogger logger, Supplier<String> errorMsg) {
        try {
            return this.expressionEvaluator.evaluate(ArrayUtils.addAll((Object[])this.getParameters(row), (Object[])new Object[]{defaultValue, logger, row}));
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            logger.error(RecordProcessingError.recordProcessingError(errorMsg.get(), cause, row));
            return defaultValue;
        }
    }

    private Object[] getParameters(GenericRow row) {
        Object[] parameters = this.threadLocalParameters.get();
        this.spec.resolve(row, parameters);
        return parameters;
    }
}

