/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.HashMap;
import java.util.Map;

public final class LambdaMappingUtil {
    private LambdaMappingUtil() {
    }

    public static Map<String, SqlType> resolveOldAndNewLambdaMapping(Map<String, SqlType> newMapping, Map<String, SqlType> oldMapping) {
        HashMap<String, SqlType> updatedMapping = new HashMap<String, SqlType>(oldMapping);
        for (Map.Entry<String, SqlType> entry : newMapping.entrySet()) {
            String key = entry.getKey();
            if (oldMapping.containsKey(key) && !oldMapping.get(key).equals(newMapping.get(key))) {
                throw new IllegalStateException(String.format("Could not map type %s to lambda variable %s, %s was already mapped to %s", newMapping.get(key).toString(), key, key, oldMapping.get(key).toString()));
            }
            updatedMapping.put(key, entry.getValue());
        }
        return updatedMapping;
    }
}

