/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.util.KsqlException;
import java.util.Optional;
import java.util.regex.Pattern;

public final class LikeEvaluator {
    private LikeEvaluator() {
    }

    public static boolean matches(String val, String pattern) {
        return LikeEvaluator.matches(val, pattern, Optional.empty());
    }

    public static boolean matches(String val, String pattern, char escape) {
        return LikeEvaluator.matches(val, pattern, Optional.of(Character.valueOf(escape)));
    }

    @VisibleForTesting
    static boolean matches(String val, String pattern, Optional<Character> escape) {
        int i;
        StringBuilder regex = new StringBuilder();
        char[] chars = pattern.toCharArray();
        boolean escaped = false;
        int start = 0;
        for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (escaped) {
                escaped = false;
                continue;
            }
            if (escape.filter(e -> e.charValue() == c).isPresent()) {
                escaped = true;
                LikeEvaluator.append(pattern, start, i, regex);
                start = i + 1;
                continue;
            }
            if (c == '%') {
                LikeEvaluator.append(pattern, start, i, regex);
                regex.append(".*");
                start = i + 1;
                continue;
            }
            if (c != '_') continue;
            LikeEvaluator.append(pattern, start, i, regex);
            regex.append(".");
            start = i + 1;
        }
        if (escaped) {
            throw new KsqlException("LIKE pattern must not end with escape character");
        }
        LikeEvaluator.append(pattern, start, i, regex);
        return Pattern.compile(regex.toString()).matcher(val).matches();
    }

    private static void append(String pattern, int start, int end, StringBuilder regex) {
        if (end - start > 0) {
            regex.append(Pattern.quote(pattern.substring(start, end)));
        }
    }
}

